; NASM MEMORY ALLOCATION EXAMPLE FOR WDOSX
; This one tries to expand the memory segment to the maximum possible size
; and prints out this value.

[BITS 32]
[ORG 0]

		; enable virtual interrupts

		mov	eax,0901h
		int	31h

		; set es = ds

		push	ds
		pop	es

		; check how much memory available

		mov	edi,FreeSpace
		mov	eax,500h
		int	31h

		; get free memory ( advisory )

		mov	edx,[edi]

		; add memory we already own

		add	edx,esp

		; try to extend the segment as much as possible

TryMalloc:
		mov	eax,-1
		int	21h
		jnc	MemDone

		; try one page less

		sub	edx,1000h
		jmp	TryMalloc

MemDone:

		; print string

		push	edx
		mov	edx,Str1
		mov	ah,9
		int	21h
		pop	eax

		; print number

		call	PrintEax

		; terminate

		mov	ah,4ch
		int	21h

; ------------- print a 32 bit number as decimal value ------------

PrintEax:
		mov	ecx,10
PrintLoop:
		sub	edx,edx
		div	ecx
		test	eax,eax
		jz	Print0
		push	edx
		call	PrintLoop
		pop	edx
Print0:
		add	dl,'0'
		mov	ah,2
		int	21h		
		retn

; ------------- *** ------------------------------------------------

Str1		db	'Maximum segment size in bytes: ','$'
FreeSpace
