; NASM EXAMPLE CODE FOR DPMI CALLBACK USE WITH WDOSX
;
; This one will install a costum mouse handler, display a 'L' in left upper
; screen corner if left button pressed, exit on right button press.
;
; ************ No error handling at all! ***************


[BITS 32]
[ORG 0]
		jmp	start

nullsel		dw	0
datasel		dw	0

; ------ the procedure that will be called from real mode -------

mousehandler:
		push	ds

                ; set return info

		push	ax

		mov	ax,[esi]
		mov	[es:edi+_ip-__rmcall],ax

		mov	ax,[esi+2]
		mov	[es:edi+_cs-__rmcall],ax

		add	word [es:edi+_sp-__rmcall],4
		mov	ds,[cs:datasel]

                ; right button pressed?

		test	word [es:edi+_bx-__rmcall],2
		jz	norbut

		mov	byte [rbpressed],1			
		jmp	outtahere
norbut:
                ; left button pressed?

		mov	al,'L'
		test	word [es:edi+_bx-__rmcall],1
		jnz	putvideo
		mov	al,' '
putvideo:
		mov	ds,[nullsel]
		mov	[0b8000h],al

outtahere:
                ; terminate the handler

		pop	ax
		pop	ds
		iretd

rbpressed	db	0

; ------------- main program goes here ---------------

start:
                ; enable virtual interrupts

		mov	ax,0901h
		int	31h

                ; store ds for use in the callback procedure

		mov	[datasel],ds

                ; get a selector to low memory

		sub	ax,ax
		mov	cx,1
		int	31h
		mov	bx,ax

                ; set the limit to 4G

		mov	ax,8
		stc
		sbb	ecx,ecx
		sbb	edx,edx
		int	31h

                ; set access rights

		lar	cx,bx
		mov	cl,ch
		and	cl,60h
		or	cl,92h
		mov	ch,0cfh
		mov	ax,9
		int	31h

                ; set descriptor base to 0

		sub	cx,cx
		sub	dx,dx
		mov	ax,7
		int	31h

                ; store selector for use in the callback procedure

		mov	[nullsel],bx

                ; reset mouse driver

		sub	ax,ax
		int	33h

                ; allocate callback

		push	ds
		pop	es
		mov	esi,mousehandler
		mov	edi,__rmcall
		push	ds
		mov	bx,cs
		mov	ds,bx
		mov	ax,0303h
		int	31h
		pop	ds

                ; install the costum mouse event handler

		mov	edi,__rmcall

		push	cx
		push	dx
		mov	[edi+_es-__rmcall],cx
		mov	[edi+_dx-__rmcall],dx
		mov	word [edi+_cx-__rmcall],0eh
		mov	word [edi+_ax-__rmcall],0ch

		mov	bl,33h
		sub	cx,cx
		mov	ax,0300h
		int	31h

                ; mouse handler now installed
                ; loop until right button pressed

havetowait:
		cmp	byte [rbpressed],0
		jz	havetowait

                ; reset the mouse driver

		sub	ax,ax
		int	33h

                ; free the previously allocated callback

		pop	dx
		pop	cx
		mov	ax,0304h
		int	31h

                ; terminate

		mov	ah,4ch
		int	21h

; realmode callback structure
__rmcall
_edi
_di	dw	0
	dw	0
_esi
_si	dw	0
	dw	0
_ebp
_bp	dw	0
	dw	0
_esp
_spl	dw	0
	dw	0
_ebx
_bx
_bl	db	0
_bh	db	0
	dw	0
_edx
_dx
_dl	db	0
_dh	db	0
	dw	0
_ecx
_cx
_cl	db	0
_ch	db	0
	dw	0
_eax
_ax
_al	db	0
_ah	db	0
	dw	0
_flags	dw	0
_es	dw	0
_ds	dw	0
_fs	dw	0
_gs	dw	0
_ip	dw	0
_cs	dw	0
_sp	dw	0
_ss	dw	0	
