program Neon;

uses mode13h,crt,sprites;

Type RgbItem=Record
                   R,G,B:Byte;
             End;
     RgbList=Array[0..255] of RgbItem;

var temp: rgblist;
    a: integer;
    x,y,z: byte;
    h: integer;

procedure start;
begin
     initgraph;
     initvirt;
end;

procedure close;
begin
     closegraph;
     closevirt;
     textcolor (yellow);
     writeln ('Crush logging off...');
     writeln ('..');
     writeln ('.');
end;

procedure fadeto (x,y,z:byte;h:integer);
var a:integer;
    r,g,b:byte;
begin
     delay (h);
     for a:=0 to 255 do
     begin
          getcolor (a,r,g,b);
          if r>x then r:=r-1;
          if r<x then r:=r+1;
          if g>y then g:=g-1;
          if g<y then g:=g+1;
          if b>z then b:=b-1;
          if b<z then b:=b+1;
          setcolor (a,r,g,b);
     end;
end;

procedure fadefrom (temp:rgblist;h:integer);
var a:integer;
    r,g,b:byte;
begin
     delay (h);
     for a:=0 to 255 do
     begin
          getcolor (a,r,g,b);
          if r>temp[a].r then r:=r-1;
          if r<temp[a].r then r:=r+1;
          if g>temp[a].g then g:=g-1;
          if g<temp[a].g then g:=g+1;
          if b>temp[a].b then b:=b-1;
          if b<temp[a].b then b:=b+1;
          setcolor (a,r,g,b);
     end;
end;

procedure savepal;
var a:integer;
begin
     for a:=0 to 255 do getcolor (a,temp[a].r,temp[a].g,temp[a].b);
end;

procedure restorepal;
var a:integer;
begin
     for a:=0 to 255 do setcolor (a,temp[a].r,temp[a].g,temp[a].b);
end;

procedure loading;
begin
     textcolor (red);
     write ('L');
     delay (30);
     write ('o');
     delay (30);
     write ('a');
     delay (30);
     write ('d');
     delay (30);
     write ('i');
     delay (30);
     write ('n');
     delay (30);
     write ('g');
     delay (30);
     write ('.');
     delay (30);
     write ('.');
     delay (30);
     write ('.');
end;

procedure questions;
begin
     textcolor (yellow);
     writeln ('What''s the first color component?(0-63)');
     textcolor (green);
     readln (x);
     textcolor (yellow);
     writeln ('What''s the second color component?(0-63)');
     textcolor (green);
     readln (y);
     textcolor (yellow);
     writeln ('What''s the third color component?(0-63)');
     textcolor (green);
     readln (z);
     textcolor (yellow);
     writeln ('What''s the fader delay?(0-100)');
     textcolor (green);
     readln (h);
end;

begin
     questions;
     loading;
     for a:=0 to 63 do fadeto (0,0,0,40);
     start;
     loadpcx ('neon.pcx',vp[1]);
     copypage (vp[1],vga);
     savepal;
     readkey;
     for a:=0 to 63 do fadeto (x,y,z,h);
     readkey;
     for a:=0 to 63 do fadefrom (temp,h);
     readkey;
     close;
end.