{ Turbo Pascal version 7.0 directive settings }
{$a+,b-,d+,e+,f-,g+,i+,l+,n-,o-,p-,q-,r-,s+,t-,v+,x+}

{ if you have a 386 or better 'uncomment' the next line }
{-$define cpu386}

program wormhole;
{ Asm-version of Wormhole, by Bas van Gaalen, Holland, PD }
uses crt,crush13h;
const
  divd=128;
  astep=4;
  xst=4;
  yst=5;
var
  sintab:array[0..449] of integer;
  stab,ctab:array[0..255] of integer;
  lstep:byte;

procedure drawpolar(xo,yo,r,a:word; c:byte; lvseg:word); assembler;
asm
  mov es,lvseg

  mov bx,a
  add bx,a
  mov cx,word ptr sintab[bx]
  add bx,2*90
  mov ax,word ptr sintab[bx]
  mul r
  mov bx,divd
  xor dx,dx
  cwd
  idiv bx
  add ax,xo
  add ax,160
  cmp ax,320
  ja @out
  mov si,ax

  mov ax,cx
  mul r
  mov bx,divd
  xor dx,dx
  cwd
  idiv bx
  add ax,yo
  add ax,100
  cmp ax,200
  ja @out

  shl ax,6
  mov di,ax
  shl ax,2
  add di,ax
  add di,si
  mov al,c
  mov [es:di],al
 @out:
end;

var x,y,i,j:word; c:byte;
begin
  video_mode ( $13);

  for i:=0 to 255 do begin
    ctab[i]:=round(cos(pi*i/128)*60);
    stab[i]:=round(sin(pi*i/128)*45);
  end;
  for i:=0 to 449 do sintab[i]:=round(sin(2*pi*i/360)*divd);

  initvirt;

  cls(0,vp[1]);
  x:=30; y:=90;
  repeat
        waitvbl;
        c:=22;
        lstep:=2;
        j:=60;

        while j<220 do
        begin
              i:=0;
              while i<360 do
              begin
                   drawpolar(ctab[(x+(200-j)) mod 255],stab[(y+(200-j)) mod 255],j,i,c,vp[1]);
                   inc(i,astep);
              end;
        inc(j,lstep);
        if (j mod 5)=0 then begin inc(lstep); inc(c); if c>31 then c:=22; end;
        end;

    x:=xst+x mod 255;
    y:=yst+y mod 255;
    copypage (vp[1],vga,0);
    cls(0,vp[1]);
  until keypressed;
  readkey;
  closevirt;
  video_mode ( 03);
end.

