unit grafix;

interface

uses
  video;

procedure putpixel(x,y:word;r,g,b:byte);
procedure clearscreen;
procedure fadedown(fade:word);
procedure fadeup(fade:word);

implementation

procedure putpixel(x,y:word;r,g,b:byte); assembler;
asm
  mov edi,[video_SCREEN]
  xor eax,eax
  mov bx,y
  shl bx,6
  mov ax,bx
  shl bx,2
  add ax,bx
  add ax,x
  shl eax,2
  add edi,eax
  mov al,r
  shl eax,16
  mov ah,g
  mov al,b
  stosd
end;

procedure clearscreen; assembler;
asm
  mov edi,[video_SCREEN]
  mov eax,0
  mov ecx,64000
  rep stosd
end;

procedure fadedown(fade:word); assembler;
asm
  cmp fade,0
  je @exit
  mov edi,[video_SCREEN]
  mov ecx,64000
  cmp fade,255
  jb @loop0
  xor eax,eax
  rep stosd
  jmp @exit
 @loop0:
  mov eax,[edi]
  mov bx,fade
  sub al,bl
  jnc @ok0
  xor al,al
 @ok0:
  sub ah,bl
  jnc @ok1
  xor ah,ah
 @ok1:
  ror eax,16
  sub al,bl
  jnc @ok2
  xor al,al
 @ok2:
  rol eax,16
  stosd
  loop @loop0
 @exit:
end;

procedure fadeup(fade:word); assembler;
asm
  cmp fade,0
  je @exit
  mov edi,[video_SCREEN]
  mov ecx,64000
  cmp fade,255
  jb @loop0
  xor eax,eax
  dec eax
  rep stosd
  jmp @exit
 @loop0:
  mov eax,[edi]
  mov bx,fade
  add al,bl
  jnc @ok0
  mov al,255
 @ok0:
  add ah,bl
  jnc @ok1
  mov ah,255
 @ok1:
  ror eax,16
  add al,bl
  jnc @ok2
  mov al,255
 @ok2:
  rol eax,16
  stosd
  loop @loop0
 @exit:
end;

begin
end.