unit ubump2;

interface

procedure bump2_init;
procedure bump2_action(map,fxlength:byte;startfade:dword);
procedure bump2_close;

implementation

uses
  crt,video,grafix,usm;

type
  tbumpmap=array[0..255999] of byte;
  pbumpmap=^tbumpmap;

var
  bumpmap0,bumpmap1,bumpmap2:pbumpmap;
  bumpmap:pointer;
  tex:array[0..65536] of dword;

  ba,bb:dword;
  ta,tb:byte;

  term:boolean;
  korder,vorder,aorder,row:byte;

procedure newint;
begin
  inc(counter);
end;

procedure makemaps;
var
  a,b:word;
  addr:dword;
begin
  addr:=0;
  for b:=0 to 399 do begin
    for a:=0 to 639 do begin
      bumpmap0^[addr]:=round(((sin(sqrt(sqr(320-a)+sqr(200-b))*1.8+90)*pi/180)*127+
                  sin((sqrt(sqr(320-a)+sqr(200-b))*5.1+90)*pi/180)*127)/2+128);
      bumpmap1^[addr]:=round(sin( sqrt(sqr(320-a)+sqr(200-b))/190 * pi )*127+128);
      bumpmap2^[addr]:=round(sin(a*13*pi/180)*10+cos(b*17*pi/180)*10)+128;
      inc(addr);
    end;
  end;
end;

procedure alloc;
begin
  new(bumpmap0);
  new(bumpmap1);
  new(bumpmap2);
  makemaps;
end;

procedure dealloc;
begin
  dispose(bumpmap0);
  dispose(bumpmap1);
  dispose(bumpmap2);
end;

procedure LoadFiles;
var
  f:file;
begin
  assign(f,'bum2_tex.dat');
  reset(f,1);
  blockread(f,tex,196608);
  close(f);
end;

procedure convertimage(image:pointer;size:dword);
begin
  asm
    mov esi,[image]
    mov edi,[image]
    mov eax,4
    mov ebx,size
    dec ebx
    mul ebx
    add edi,eax
    mov eax,3
    mul ebx
    add esi,eax
    mov ecx,size
   @loop0:
    mov eax,[esi]
    mov bh,ah
    ror eax,16
    mov ah,bh
    mov [edi],eax
    sub esi,3
    sub edi,4
    loop @loop0
  end;
end;

procedure render; assembler;
asm
    mov eax,640
    mul bb
    add eax,ba
    add eax,[bumpmap]
    mov esi,eax

    mov edi,[video_screen]

    xor edx,edx
   @loopy:

    xor ecx,ecx
   @loopx:
    xor eax,eax
    mov al,[esi]
    inc esi
    shr al,1
    mov ah,al
    add al,cl
    add al,ta
    add ah,dl
    add ah,tb
    shl eax,2

    mov ebx,eax
    mov eax,dword ptr tex[ebx]

    mov [edi],eax
    add edi,4

    inc ecx
    cmp ecx,319
    jbe @loopx

    add esi,320
    inc edx
    cmp edx,199
    jbe @loopy
end;

procedure bump2_init;
begin
  alloc;
  loadfiles;
  convertimage(@tex,65536);
end;

procedure bump2_action(map,fxlength:byte;startfade:dword);
begin
  term:=false;
  counter:=0;
  case map of
    0: bumpmap:=bumpmap0;
    1: bumpmap:=bumpmap1;
    2: bumpmap:=bumpmap2;
  end;
  asm
   mov al,[_order]
   mov korder,al
  end;
  vorder:=korder+fxlength;
  USS_SetTimer(@newint,timerspeed div 80);
  Repeat
    ba:=trunc(cos(counter*pi/180)*80+160);
    bb:=trunc(sin(counter*pi/180)*80+100);
    ta:=trunc(sin((counter+60)*pi/180)*160+128);
    tb:=trunc(sin((counter+170)*pi/180)*160+128);
    render;
    if counter<256 then fadedown(255-counter);
    if counter>=startfade then fadedown((counter-startfade)*2);
    video_copy;
    asm
     mov al,[_order]
     mov aorder,al
    end;
    if (aorder=vorder) then term:=true;
    if TerminateDemo Then Begin USS_StopTimer(@newint); ExitDemo; End;
  Until{ (KeyPressed) or} (Term);
  while keypressed do readkey;
  USS_StopTimer(@newint);
end;

procedure bump2_close;
begin
  dealloc;
end;

begin
end.