; (C)oded by Sergey Chaban

CopyTextString:
 pop ax
 xchg ax,si
 push ax
@@Copy:
 lodsb
 test al,al
 jz @@Done
 stosb
 jmp @@Copy
@@Done:
 pop ax
 xchg ax,si
 jmp ax


Matrix2Int proc
 push bx cx di
 mov cx,3*3
@@Loop:
 fld dword ptr [bx]
 fmul dword ptr [fp_Scale16]
 fistp dword ptr [di]
 add bx,4
 add di,4
 loop @@Loop
 pop di cx bx
 ret
endp

Debug_CopyQuat:
 push bx
 mov bx,offset dbg_TempQuat
 Num=0
 REPT 4
 mov eax,dword ptr fs:[si+Num].Key_Rotation
 mov [bx+Num],eax
 Num=Num+4
 ENDM
 mov si,bx
 pop bx
 ret

DumpConvertedTrack PROC
 _PrintMode 2
 mov es,word ptr ds:[DebugBuffer]
 xor di,di
 print <============= Original track ===============\n\n>
 mov fs,word ptr ds:[TrackData]
 mov si,SIZE KeyFrame
 mov cx,PointsPerTrack
@@Loop:
 push cx
 printl <\n------------->

 printl <Time=>,dword,fs:[si].Key_FrameNumber
 print  <\nPosition:\n>
 print  <Vector(>,float,fs:[si].Key_Position.VecX
 print  <,>,float,fs:[si].Key_Position.VecY
 print  <,>,float,fs:[si].Key_Position.VecZ
 print  <)\n>
 print  <C:>,float,fs:[si].Key_PosParameters.fContinuity
 print  < T:>,float,fs:[si].Key_PosParameters.fTension
 printl < B:>,float,fs:[si].Key_PosParameters.fBias
 print  <\nout slope:\n>
 print  <Vector(>,float,fs:[si].Key_Tout.VecX
 print  <,>,float,fs:[si].Key_Tout.VecY
 print  <,>,float,fs:[si].Key_Tout.VecZ
 print  <)\n>
 print  <\nin slope:\n>
 print  <Vector(>,float,fs:[si].Key_Tin.VecX
 print  <,>,float,fs:[si].Key_Tin.VecY
 print  <,>,float,fs:[si].Key_Tin.VecZ
 print  <)\n>
 print  <\nRotation:\n>
 printl < Quat: W:>,float,fs:[si].Key_Rotation.Quat_W
 printl <       X:>,float,fs:[si].Key_Rotation.Quat_X
 printl <       Y:>,float,fs:[si].Key_Rotation.Quat_Y
 printl <       Z:>,float,fs:[si].Key_Rotation.Quat_Z

 print  <\n control point in:\n>
 print  <quat(>,float,fs:[si].Key_C_in.Quat_W
 print  <,>,float,fs:[si].Key_C_in.Quat_X
 print  <,>,float,fs:[si].Key_C_in.Quat_Y
 print  <,>,float,fs:[si].Key_C_in.Quat_Z
 print  <)\n>
 print  <\n control point out:\n>
 print  <quat(>,float,fs:[si].Key_C_out.Quat_W
 print  <,>,float,fs:[si].Key_C_out.Quat_X
 print  <,>,float,fs:[si].Key_C_out.Quat_Y
 print  <,>,float,fs:[si].Key_C_out.Quat_Z
 print  <)\n>


 push si
 call Debug_CopyQuat
 mov bx,offset dbg_TempEuler
 call Quaternion2Angles
 pop si
 movzx ax,dh
 push ax
 mov ax,dbg_TempEuler.Angle_X
 printl <\n       AngleX=>,register,ax ;short,dbg_TempEuler.Angle_X
 mov ax,dbg_TempEuler.Angle_Y
 printl <       AngleY=>,register,ax ;short,dbg_TempEuler.Angle_Y
 mov ax,dbg_TempEuler.Angle_Z
 printl <       AngleZ=>,register,ax ;short,dbg_TempEuler.Angle_Z
 pop ax
 printl <\n Flag: >,register,ax


 printl <\n       C:>,float,fs:[si].Key_RotParameters.fContinuity
 printl <       T:>,float,fs:[si].Key_RotParameters.fTension
 printl <       B:>,float,fs:[si].Key_RotParameters.fBias
 pop cx
 add si,SIZE KeyFrame
 dec cx
 jnz @@Loop
 SaveBytes di
 ret
DumpConvertedTrack ENDP

EVENDATA

DumpFileHandle dw 0

dbg_TempQuat  Quaternion  <>
dbg_TempEuler EulerAngles <>



DumpInterpolated PROC
 _PrintMode 2
 mov word ptr ds:[CurrentTrackPointPtr],SIZE KeyFrame
 mov dword ptr ds:[TimeCounter],0
 mov cx,12 ;PointsPerTrack
@@Loop:
 pusha
 mov si,offset Camera_Data
 call InterpolateTrack
 mov es,word ptr ds:[DebugBuffer]
 xor di,di
 printl <\n -------------------time: >,dword,[TimeCounter]
 printl <\n X:>,float,[si].Camera_Position.VecX
 printl < Y:>,float,[si].Camera_Position.VecY
 printl < Z:>,float,[si].Camera_Position.VecZ

;IF 0
 printl <\n q.W: >,float,[si].Camera_QuatRot.Quat_W
 printl < q.X: >,float,[si].Camera_QuatRot.Quat_X
 printl < q.Y: >,float,[si].Camera_QuatRot.Quat_Y
 printl < q.Z: >,float,[si].Camera_QuatRot.Quat_Z

; if 0
 mov bx,offset dbg_TempEuler
 add si,offset Camera_QuatRot
 call Quaternion2Angles
 mov ax,dbg_TempEuler.Angle_X
 printl <\n       AngleX=>,register,ax ;short,dbg_TempEuler.Angle_X
 mov ax,dbg_TempEuler.Angle_Y
 printl <       AngleY=>,register,ax ;short,dbg_TempEuler.Angle_Y
 mov ax,dbg_TempEuler.Angle_Z
 printl <       AngleZ=>,register,ax ;short,dbg_TempEuler.Angle_Z
; endif
;ENDIF

 SaveBytes di
 popa
 add [TimeCounter],1000 ;/2
 dec cx
 jnz @@Loop
 ret
ENDP


DumpPoly2Draw PROC
 pushad
 push es
 mov es,word ptr ds:[DebugBuffer]
 _PrintMode 4
 push cx
 xor di,di
 printl <******************>
 printl <Number of vertices: >,register,cx
 SaveBytes di
 pop cx
@@loop:
 push cx
 xor di,di
 printl <\n X:>,float,[si].Vertex_Coords.VecX
 printl < Y:>,float,[si].Vertex_Coords.VecY
 printl < Z:>,float,[si].Vertex_Coords.VecZ
 print <\n sx:>,short,[si].Vertex_ScreenX
 print <(.>,ushort,[si].Vertex_ScreenX_Frac
 print <)\n>
 printl < sy:>,short,[si].Vertex_ScreenY
 printl <-->
 SaveBytes di
 add si,SIZE VertexData
 pop cx
 dec cx
 jnz @@loop
 pop es
 popad
 ret
ENDP

DumpClippedPoly proc
 pushad
 push es
 mov es,word ptr ds:[DebugBuffer]
 sub di,di
 printl <\nAfter clipping:>
 mov ax,cx
 mov dl,SIZE PolyCache
 div dl
 push ax
 printl <vertices: >,register,ax
 SaveBytes di
 pop cx
 xor bp,bp
@@loop:
 push bp cx
 sub di,di
 print <\n! #>,register,bp
 print <  sx:>,short,[si].PolyCache_X
 print <(.>,ushort,[si].PolyCache_X_Frac
 print <)\n>
 printl <          sy:>,short,[si].PolyCache_Y
 SaveBytes di
 add si,SIZE PolyCache
 pop cx bp
 inc bp
 dec cx
 jnz @@loop
 pop es
 popad
 ret
ENDP

EVEN
DebugBuffer dw 0
