; Chip Trixx utility
; (C) Sergey Chaban

.486p
LOCALS @@



cseg segment para use16
 assume cs:cseg, ds:cseg

  org 100h

include mydefs.def
include engine.def
include fixed.mac
include keyframe.def

Start:
 jmp __go
 EVENDATA

 include camtrack.def

EventStr db 'Event_'
EventNumID db 'x = 0'
EventTime db 'xxxxh',0Dh,0Ah
EventStr_Size = $ - offset EventStr


IncFileName db 'camtrack.inc',0

__pmsg db 'PointsPerTrack=0'
__pcount db '0000h',13,10,13,10
__pmsg_size = $-offset __pmsg

__label db 13,10,'CameraTrack LABEL byte',13,10,13,10
__label_size = $-offset __label



Byte2Hex:
 mov ah,al
 shr al,4
 call Nibble2Hex
 and al,0Fh
Nibble2Hex:
 add al,90h
 daa
 adc al,40h
 daa
 xchg al,ah
 ret



PokeEvent MACRO ID
 dw Event_&ID
ENDM

EVENDATA

IF EventsCount
 EventID=1
EventsFrameNumbers LABEL word
  REPT EventsCount
   PokeEvent %EventID
   EventID=EventID+1
  ENDM
SaveEvents:
 push ds
 pop es
 mov si,offset EventsFrameNumbers
 mov cx,EventsCount
 mov al,'1'
evloop:
 push cx
 mov byte ptr ds:[EventNumID],al
 push ax
 mov di,offset EventTime
 mov al,[si+1]
 call Byte2Hex
 stosw
 lodsw
 call Byte2Hex
 stosw
 mov dx,offset EventStr
 mov cx,EventStr_Size
 DOSCALL 40h
 pop ax
 inc ax
 pop cx
 loop evloop
 ret
ELSE
SaveEvents:
 push ds
 pop es
 ret
ENDIF



__go:
 cld
 push cs
 pop es
 mov dx,offset IncFileName
 sub cx,cx
 DOSCALL 3Ch
 xchg bx,ax
 mov si,offset CameraTrack - SIZE KeyFrame_Raw
 mov cx,PointsPerTrack
 pusha
 mov di,offset __pcount
 mov al,ch
 call Byte2Hex
 stosw
 mov al,cl
 call Byte2Hex
 stosw
 mov dx,offset __pmsg
 mov cx,__pmsg_size
 DOSCALL 40h
 popa
 inc cx ; Don't forget about auxiliary points
 inc cx
 mov ax,cs
 add ah,10h
 mov es,ax
 xor bp,bp
__loop:
 cmp bp,1
 jnz __nolabel
 pusha
 mov dx,offset __label
 mov cx,__label_size
 DOSCALL 40h
 popa
__nolabel:
 sub di,di
 mov ax,'bd'
 stosw
 mov al,' '
 stosb
 push cx
 mov cx,SIZE KeyFrame_Raw
__line_loop:
 mov al,'0'
 stosb
 lodsb
 call Byte2Hex
 stosw
 mov ax,',h'
 cmp cl,1
 jne __nope
 stosb
 mov ax,0A0Dh  ; EOL
__nope:
 stosw
 loop __line_loop
 pusha
 push ds
 sub dx,dx
 mov cx,di
 push es
 pop ds
 DOSCALL 40h
 pop ds
 popa
 pop cx
 inc bp
 loop __loop

 call SaveEvents

 DOSCALL 3Eh
 int 20h


cseg ends
end Start
