; Basic quaternion operations
; (C)oded by Sergey Chaban

CopyVector proc
 xchg ax,si
 fld dword ptr [si].VecX
 fstp dword ptr [bx].VecX
 fld dword ptr [si].VecY
 fstp dword ptr [bx].VecY
 fld dword ptr [si].VecZ
 fstp dword ptr [bx].VecZ
 xchg ax,si
 ret
CopyVector endp

IF 0  ; Removed because unused. Unused because unoptimal. :-)
      ; This calculates matrix for the object space.
      ; In order to get camera matrix we need to transpose the result.
      ; We also calculate many items as twice as needed.
      ; High speed conversion used instead (see Keyframe.asm).
; Derive rotation matrix from quaternion q=[w,(x,y,z)]
; [bx]=q
; [di]=resulting matrix
;     [ 1-2yy-2zz    -2xy-2wz    2xz-2wy ]
;     [   2wz-2xy   1-2xx-2zz   -2yz-2wx ]
;     [   2xz+2wy     2wx-2yz  1-2xx-2yy ]
Quaternion_Convert2Matrix proc
 fld dword ptr [bx].Quat_Y
 fmul st,st(0)               ; yy
 fld dword ptr [bx].Quat_Z
 fmul st,st(0)               ; zz, yy
 faddp st(1),st              ; yy+zz
 fadd st,st(0)               ; 2*(yy+zz)=2yy+2zz
 fsubr dword ptr ds:[fp_One] ; 1-(2yy+2zz)=1-2yy-2zz
 fstp dword ptr [di].matr_Xx
 ;*********
 fld dword ptr [bx].Quat_X
 fmul dword ptr [bx].Quat_Y  ; xy
 fld dword ptr [bx].Quat_W
 fmul dword ptr [bx].Quat_Z  ; wz, xy
 faddp st(1),st              ; xy+wz
 fadd st,st(0)               ; 2*(xy+wz)=2xy+2wz
 fchs                        ; -2xy-2wz
 fstp dword ptr [di].matr_Xy
 ;*********
 fld dword ptr [bx].Quat_X
 fmul dword ptr [bx].Quat_Z  ; xz
 fld dword ptr [bx].Quat_W
 fmul dword ptr [bx].Quat_Y  ; wy, xz
 fsubp st(1),st              ; xz-wy
 fadd st,st(0)               ; 2*(xz-wy)=2xz-2wy
 fstp dword ptr [di].matr_Xz
 ;*********
 fld dword ptr [bx].Quat_X
 fmul dword ptr [bx].Quat_Y  ; xy
 fld dword ptr [bx].Quat_W
 fmul dword ptr [bx].Quat_Z  ; wz, xy
 fsubrp st(1),st             ; wz-xy
 fadd st,st(0)               ; 2*(wz-xy)=2wz-2xy
 fstp dword ptr [di].matr_Yx
 ;*********
 fld dword ptr [bx].Quat_X
 fmul st,st(0)               ; xx
 fld dword ptr [bx].Quat_Z
 fmul st,st(0)               ; zz, xx
 faddp st(1),st              ; xx+zz
 fadd st,st(0)               ; 2*(xx+zz)=2xx+2zz
 fsubr dword ptr ds:[fp_One] ; 1-(2xx+2zz)=1-2xx-2zz
 fstp dword ptr [di].matr_Yy
 ;*********
 fld dword ptr [bx].Quat_Y
 fmul dword ptr [bx].Quat_Z  ; yz
 fld dword ptr [bx].Quat_W
 fmul dword ptr [bx].Quat_X  ; wx, yz
 faddp st(1),st              ; yz+wx
 fadd st,st(0)               ; 2*(yz+wx)=2yz+2wx
 fchs                        ; -2yz-2wx
 fstp dword ptr [di].matr_Yz
 ;*********
 fld dword ptr [bx].Quat_X
 fmul dword ptr [bx].Quat_Z  ; xz
 fld dword ptr [bx].Quat_W
 fmul dword ptr [bx].Quat_Y  ; wy, xz
 faddp st(1),st              ; xz+wy
 fadd st,st(0)               ; 2*(xz+wy)=2xz+2wy
 fstp dword ptr [di].matr_Zx
 ;*********
 fld dword ptr [bx].Quat_Y
 fmul dword ptr [bx].Quat_Z  ; yz
 fld dword ptr [bx].Quat_W
 fmul dword ptr [bx].Quat_X  ; wx, yz
 fsubrp st(1),st             ; wx-yz
 fadd st,st(0)               ; 2*(wx-yz)=2wx-2yz
 fstp dword ptr [di].matr_Zy
 ;*********
 fld dword ptr [bx].Quat_X
 fmul st,st(0)               ; xx
 fld dword ptr [bx].Quat_Y
 fmul st,st(0)               ; yy, xx
 faddp st(1),st              ; xx+yy
 fadd st,st(0)               ; 2*(xx+yy)=2xx+2yy
 fsubr dword ptr ds:[fp_One] ; 1-(2xx+2yy)=1-2xx-2yy
 fstp dword ptr [di].matr_Zz
 ret
Quaternion_Convert2Matrix endp
ENDIF ;// end of removed code


; [SI]=q1=[W1,V1]
; [DI]=q2=[W2,V2]
; [BX]=empty quaternion to store result
;Out:
; [BX]=q1*q2=[W1W2 - Dot(V1,V2), Cross(V1,V2)+W1V2+W2V1]
Quaternion_Multiply proc
 push bx
 push si di
 ; lea bx,[bx].Quat_Scalar
 lea bp,[si].Quat_Vector  ; V1
 lea dx,[di].Quat_Vector  ; V2
 mov si,bp
 mov di,dx
 call VectorMath_DotProduct
 pop di si
 fld dword ptr [si].Quat_Scalar
 fmul dword ptr [di].Quat_Scalar
 fsub dword ptr [bx]
 fstp dword ptr [bx]
 lea cx,[bx].Quat_Vector
 mov ax,dx               ; V2
 mov bx,offset Vec_W1V2
 call CopyVector
 fld dword ptr [si].Quat_Scalar
 call VectorMath_MulByScalar
 mov ax,bp
 mov bx,offset Vec_W2V1
 call CopyVector
 fld dword ptr [di].Quat_Scalar
 call VectorMath_MulByScalar
 mov bx,offset Vec_V1V2Cross
 mov si,bp
 mov di,dx
 call VectorMath_CrossProduct
 mov bx,cx
 mov si,offset Vec_W1V2
 mov di,offset Vec_W2V1
 call VectorMath_Add
 mov si,bx
 mov di,offset Vec_V1V2Cross
 call VectorMath_Add ; Concat
 pop bx
 ret
Quaternion_Multiply endp

;* Here comes famous Spherical Linear intERPolation (AKA SLERP)
;* slerp(q1,q2,t)=sin((1-t)*a)/sin(a)*q1+sin(t*a)/sin(a)*q2
;* a is the angle between q1 and q2
; IN: SI=q1 ptr (from)
;     DI=q2 ptr (to)
;     ST=t (blend factor [0..1])
;     BX=ptr to quaternion to store result in
Slerp proc
 push bx
 fldz
 sub bx,bx
@@CalcDotProd:
 fld dword ptr [si+bx]
 fmul dword ptr [di+bx]
 faddp st(1),st
 add bx,4
 cmp bx,SIZE Quaternion
 jb @@CalcDotProd
 ;* Now make sure we're traveling along the shortest arc on the
 ;* quaternion sphere. This can be checked using the following
 ;* relation:
 ;* (q1+q2)dot(q1+q2)<(q1-q2)dot(q1-q2),
 ;* if this is true we're need to negate destination quaternion q2
 ;* and use linear interpolation instead of spherical.
 ;* Is there an easier way to do this?
 fldz
 sub bx,bx
 fld st(0)              ; d1=0,d2=0 - accumulators for dot products
@@CalcDots:
 fld dword ptr [si+bx]
 fld dword ptr [di+bx]
 fld st(0)              ; q2,q2,q1,d1,d2
 fadd st,st(2)          ; q1+q2,q2,q1,d1,d2
 fxch                   ; q2,q1+q2,q1,d1,d2
 fsubp st(2),st         ; q1+q2,q1-q2,d1,d2
 fmul st,st(0)
 fxch
 fmul st,st(0)
 fxch
 faddp st(2),st         ; q1-q2,d1,d2
 faddp st(2),st         ; d1,d2
 add bx,4
 cmp bx,SIZE Quaternion
 jb @@CalcDots
 fcompp
 GetFPUFlags
 ;;setb dh
 jb @@DoShort
 pop bx
 ; Now we have dot product q1*q2=cos(a) => a=arccos(q1*q2)
 ; arccos(x)=arctan(sqrt(1-x^2)/x)
 fld st(0)                    ; x=dot=cos
 fmul st,st(0)                ; x^2, x, t
 fsubr dword ptr ds:[fp_One]  ; 1-x^2, x, t
 fcom dword ptr ds:[fp_SlerpTolerance]
 GetFPUFlags
 jae @@Slerp
 ; 1-cos(a)*cos(a)<0.000001 => abs[cos(a)]>0.99(9) => a is very close to 0
 ;* Angle is too small -> q1 and q2 are very close to each other ->
 ;* -> we can (we must) use a normal linear interpolation
 fcompp                   ; remove x^2 and x
 fld st(0)
 fsubr dword ptr ds:[fp_One]  ; 1-t, t
 jmp @@Calc
 ;* Angle is large enough and we're moving at the shortest path,
 ;* so interpolate spherically.
@@Slerp:
 ; arccos(x)=arctan(sqrt(1-x^2)/x)
 fsqrt
 fld st(0)                    ; sqrt(1-x^2), sqrt(1-x^2), x, t
 ; cos(a)=dot=x; cos^2(a)+sin^2(a)=1 => sin(a)=sqrt(1-cos^2(a))=sqrt(1-x^2)
 fdivr dword ptr ds:[fp_One]  ; 1/sin(a)
 fxch st(2)                   ; x, sqrt(1-x*x), 1/sin(a), t
 fpatan                       ; a=arctan (st(1)/st), 1/sin(a), t
 fld st(0)                    ; a, a, 1/sin(a), t
 fmul st,st(3)                ; t*a, a, 1/sin(a), t
 fsin                         ; sin(t*a), a, 1/sin(a), t
 fmul st,st(2)                ; sin(t*a)/sin(a), a, 1/sin(a), t
 fxch st(3)                   ; t, a, 1/sin(a), sin(t*a)/sin(a)
 fsubr dword ptr ds:[fp_One]  ; 1-t, a, 1/sin(a), sin(t*a)/sin(a)
 fmulp st(1),st               ; (1-t)*a, 1/sin(a), sin(t*a)/sin(a)
 fsin                         ; sin((1-t)*a), 1/sin(a), sin(t*a)/sin(a)
 fmulp st(1),st               ; sin((1-t)*a)/sin(a), sin(t*a)/sin(a)
@@Calc:
 push si di bx
 xchg di,bx
 mov cx,4
 sub bx,si
@@qMulAdd:
 fld dword ptr [si]           ; q1.n, (1-t), t
 fmul st,st(1)                ; (1-t)*q1.n, (1-t), t
 fld dword ptr [si+bx]        ; q2.n, (1-t)*q1.n, (1-t), t
 fmul st,st(3)                ; t*q2.n, (1-t)*q1.n, (1-t), t
 faddp st(1),st               ; (1-t)*q1.n+t*q2.n, (1-t), t
 add si,4
 fstp dword ptr [di]
 add di,4
 loop @@qMulAdd
@@Done:
 pop bx di si
 fcompp                       ; remove scale factors
 ret
@@DoShort:
 pop bx
 fstp st(0)                   ; remove dot
 fld st(0)
 fsubr dword ptr ds:[fp_One]  ; 1-t,t
 IF 0 ; experimental, removed for now
  fldpi
  fmul dword ptr ds:[fp_Half]
  fmul st(2),st                ; (1-t)*(PI/2),t
  fmulp st(1),st               ; (1-t)*(PI/2),t*(PI/2)
  fxch
  fsin
  fxch
  fsin                         ; sin[(1-t)*(pi/2)],sin[t*(pi/2)]
 ENDIF
 push si di bx
 xchg di,bx
 mov cx,4
 sub bx,si
 ; to=-q2
@@calcshort:
 fld dword ptr [si]           ; q1.n, (1-t), t
 fmul st,st(1)                ; (1-t)*q1.n, (1-t), t
 fld dword ptr [si+bx]        ; q2.n, (1-t)*q1.n, (1-t), t
 fmul st,st(3)                ; t*q2.n, (1-t)*q1.n, (1-t), t
 fsubp st(1),st               ; (1-t)*q1.n-t*q2.n, (1-t), t
 add si,4
 fstp dword ptr [di]
 add di,4
 loop @@calcshort
 jmp @@Done
Slerp endp

;** Convert Euler angles to quaternion
; Note: camera must be properly initialized before calling this
; IN:  SI=ptr to angles
; OUT: BX=ptr to resulting quaternion
Angles2Quaternion proc
 sub eax,eax
 ;** qroll=[cos(x/2),(sin(x/2),0,0)]
 mov di,offset FPU_Temp
 movzx ebx,word ptr [si].Angle_X
 mov [di],ebx
 fild dword ptr [di]
 fmul dword ptr Camera_Data.Camera_Radians
 fsincos
 fstp dword ptr qroll.Quat_W
 fstp dword ptr qroll.Quat_X
 mov  dword ptr qroll.Quat_Y,eax
 mov  dword ptr qroll.Quat_Z,eax
 ;** qpitch=[cos(y/2),(0,sin(y/2),0)]
 mov bx,word ptr [si].Angle_Y
 mov [di],bx
 fild dword ptr [di]
 fmul dword ptr Camera_Data.Camera_Radians
 fsincos
 fstp dword ptr qpitch.Quat_W
 fstp dword ptr qpitch.Quat_Y
 mov  dword ptr qpitch.Quat_X,eax
 mov  dword ptr qpitch.Quat_Z,eax
 ;** qyaw=[cos(z/2),(0,0,sin(z/2)]
 mov bx,word ptr [si].Angle_Z
 mov [di],bx
 fild dword ptr [di]
 fmul dword ptr Camera_Data.Camera_Radians
 fsincos
 fstp dword ptr qyaw.Quat_W
 fstp dword ptr qyaw.Quat_Z
 mov  dword ptr qyaw.Quat_X,eax
 mov  dword ptr qyaw.Quat_Y,eax
 ; Calc Y*X*Z quaternion
 mov bx,offset qrot1
 mov si,offset qpitch
 mov di,offset qroll
 call Quaternion_Multiply ; qrot1=Y*X=qpitch*qroll
 mov bx,offset qrot
 mov si,offset qrot1
 mov di,offset qyaw
 call Quaternion_Multiply ; qrot=(Y*X)*Z=qpitch*qroll*qyaw
 ret
Angles2Quaternion endp


IFDEF __DEBUG

; SI=Ptr to quaternion
; BX=Ptr to resulting Eulear angles
Quaternion2Angles proc
 fldpi
 fadd st,st(0)
 fdivr dword ptr ds:[fp_Scale16]        ; r2w=radii2word=10000h/(2*PI)

 ; Rotate vector (0,0,1) using the quaternion and use it to calculate
 ; rotations around X and Y axes.
 fld dword ptr [si].Quaternion.Quat_W
 fmul dword ptr [si].Quaternion.Quat_X  ; wx
 fld dword ptr [si].Quaternion.Quat_Y
 fmul dword ptr [si].Quaternion.Quat_Z  ; yz, wx
 fsubp st(1),st                         ; wx-yz
 fadd st,st(0)                          ; Yz=2wx-2yz
 fld dword ptr [si].Quaternion.Quat_X
 fmul st,st(0)                          ; xx
 fld dword ptr [si].Quaternion.Quat_Y
 fmul st,st(0)                          ; yy
 faddp st(1),st                         ; xx+yy
 fadd st,st(0)                          ; 2xx+2yy
 fsubr dword ptr ds:[fp_One]            ; Zz=1-2xx-2yy
 fld st(0)
 fmul st,st(2)                          ; Zz*Yz, Zz, Yz, r2w
 fld dword ptr [si].Quaternion.Quat_X
 fmul dword ptr [si].Quaternion.Quat_Z  ; xz
 fld dword ptr [si].Quaternion.Quat_W
 fmul dword ptr [si].Quaternion.Quat_Y  ; wy, xz
 faddp st(1),st                         ; xz+wy
 fadd st,st(0)                          ; Xz=2xz+2wy
 ; Xz, Zz*Yz, Zz, Yz, r2w
 fld st(2)                              ; Zz, Xz, Zz*Yz, Zz, Yz, r2w


 sub dl,dl
 fld st(1)
 fabs
 fld st(1)
 fabs                                   ; |Zz|, |Xz|
 fcompp                                 ; ABS(Zz)?ABS(Xz)
 GetFPUflags
 ja @@zGreater
 inc dx
 fld st(1)
 fstp st(4)
@@zGreater:

 fpatan                                 ; _y=arctan(Xz/Zz)
 fxch
 ; Zz*Yz, _y, MAX(Xz,Zz), Yz,  r2w
 ftst
 GetFPUFlags
 fstp st(0)
 ja @@YZok
 fldpi
 fsubp st(1),st
@@YZok:
 fld st(2)
 ftst
 GetFPUFlags
 fstp st(0)
 ja @@Yok
 fldpi
 fsubp st(1),st
@@Yok:
 ; _y, MAX(Zz,Xz), Yz, r2w


 fld st(0)
 fmul st,st(4)
 fistp dword ptr [bx].EulerAngles.Angle_Y ; !DWORD

 test dl,dl
 jz @@Cos
 fsin
 jmp @@Div
@@Cos:
 fcos
@@Div:
 fdivp st(1),st

 fpatan                                ; _x=arctan(Yz/MAX(Xz,Zz))
 fmul st,st(1)
 fistp word ptr [bx].EulerAngles.Angle_X

 fld dword ptr [si].Quaternion.Quat_W
 fmul dword ptr [si].Quaternion.Quat_Z
 fld dword ptr [si].Quaternion.Quat_X
 fmul dword ptr [si].Quaternion.Quat_Y
 faddp st(1),st
 fadd st,st(0)      ; 2xy+2wz
 fld dword ptr [si].Quaternion.Quat_X
 fmul st,st(0)
 fld dword ptr [si].Quaternion.Quat_Z
 fmul st,st(0)
 faddp st(1),st
 fadd st,st(0)
 fsubr dword ptr ds:[fp_One] ; 1-2xx-2zz
 fpatan
 fmulp st(1),st
 fistp word ptr [bx].EulerAngles.Angle_Z
 ; adjust Z angle
 test byte ptr [bx].EulerAngles.Angle_X+1,1100b SHL 4 ; high nibble
 setnp al
 setnz ah
 and al,ah
 ror al,1
 xor byte ptr [bx].EulerAngles.Angle_Z+1,al
 ret
endp
ENDIF
