#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include "..\h\AE3DS.h"
#include "..\h\console.h"


// envoke the 3ds loader
int AE3DS::Load3ds(char *FName) {
	int res;

	FileName=FName;
	res=Load3ds();
	return res;
}


// builds a linked list from the nodes
// for fast parent/child detection
// (usually called with EVE, which is the
// super-parent node
void AE3DS::BuildTree(AENODE *prev)
{
bool	First=true;
AENODE	*sister=NULL;

	for (int i=0;i<NumNodes;i++) {
			if ((Nodes[i]->Type==OBJECTNODE) ||
				(Nodes[i]->Type==CAMERANODE) ||
				(Nodes[i]->Type==CTARGETNODE) ||
				(Nodes[i]->Type==LIGHTNODE)) {
				if (Nodes[i]->Parent==prev->ID && Nodes[i]!=prev) {
					if (First) {
						prev->FirstDaughter=Nodes[i];
						First=false;
					} else {
						sister->NextSister=Nodes[i];
						Nodes[i]->PrevSister=sister;
					}
					sister=Nodes[i];
					BuildTree(sister);
				}
			}
	}
}