#include "..\h\AE.h"
#include "..\h\AEKeyfr.h"
#include "..\h\console.h"

float AESPLINE::Ease(float t, float a, float b) {
  float k;
  float s = a + b;
  
  if (s == 0.0) return t;
  if (s > 1.0) {
    a = a/s;
    b = b/s;
  };
  k = 1.0f/(2.0f-a-b);

  if (t < a)     return (k/a)*t*t;
  if (t > 1.0f-b) return (2.0f - (k/b)*t)*t;
  return k*(2.0f*t - a);
};

Quaternion AEROTTRACK::Slerp(Quaternion &q1, Quaternion &q2, float t)
{
	float   a,x,y,argu;
	Quaternion    q0;
	
	argu=q1*q2;
	if (fabs(argu)<0.9999) 
	{
		a=(float)acos(argu);
        x=(float)sin((1-t)*a)/(float)sin(a);
        y=(float)sin(t*a)/(float)sin(a);

        q0.x=q1.x*x+q2.x*y;
        q0.y=q1.y*x+q2.y*y;
        q0.z=q1.z*x+q2.z*y;
        q0.w=q1.w*x+q2.w*y;
	}
	else 
	{
		q0.x=q1.x+t*(q2.x-q1.x);     
		q0.y=q1.y+t*(q2.y-q1.y);
		q0.z=q1.z+t*(q2.z-q1.z);
		q0.w=q1.w+t*(q2.w-q1.w);
	}
	return(q0);
}

//enum {an,bn,point};

Quaternion AEROTTRACK::getq(int sel, int n, int mode) 
{
	AEROTKEY *kn_1, *kn, *kn1;
	Quaternion *qn_1, *qn, *qn1;
	int d1, d2;

	kn = &(Key[n]);
	qn = &(kn->Pos);

	if (sel == point) return *qn;

	if (n == 0)
	{
  		kn1 = &(Key[1]);
		qn1 = &(kn1->Pos);

		if (mode != 3 || NumKeys <= 2) //first key, no loop
			return Slerp(*qn,*qn1,(1.0f - kn->Tens)*(1.0f + kn->Cont*kn->Bias)/3.0f);
		else 	//first key, loop
		{
			kn_1= &(Key[NumKeys-2]);
			d1 = Key[NumKeys-1].Frame - kn_1->Frame;
			d2 = kn1->Frame - kn->Frame;
		}
	}
	else 
	if (n == LastKey)
	{
		kn_1 = &(Key[n-1]);
		qn_1 = &(kn_1->Pos);

		if (mode != 3 || NumKeys <= 2) //last key, no loop
			return Slerp(*qn,*qn_1,(1.0f - kn->Tens)*(1.0f - kn->Cont*kn->Bias)/3.0f);
		else //last key, loop
		{
			kn1 = &(Key[1]);
			d1 = kn->Frame - kn_1->Frame;
			d2 = kn1->Frame - Key[0].Frame;
		}
	} 
	else //middle keys
	{
		kn_1= &(Key[n-1]);
		kn1 = &(Key[n+1]);
		d1 = kn->Frame - kn_1->Frame;
		d2 = kn1->Frame - kn->Frame;
	}
	qn_1= &(kn_1->Pos);
	qn1 = &(kn1->Pos);

	float f;
	float adjust;

	if (sel == an) 
	{
		f = 1;
		adjust = (float)d1;
	} 
	else 
	{
		f = -1;
		adjust = (float)d2;
	}
	adjust /= d1 + d2;
	adjust = 0.5f + (1.0f - (float)fabs(kn->Cont))*(adjust - 0.5f);

	Quaternion g1,g2;
	
	g1 = Slerp(*qn,*qn_1,-(1.0f + kn->Bias)/3.0f);
	g2 = Slerp(*qn,*qn1, (1.0f - kn->Bias)/3.0f);

	return Slerp(*qn,Slerp(g1,g2,0.5f + f*0.5f*kn->Cont),f*(kn->Tens - 1.0f)*adjust*2.0f);
}

void AEROTTRACK::Init()
{
	int j;
	Quaternion elozo,uj;

	CurrKey=0;
	LastKey = NumKeys-1;
	LastFrame = Key[LastKey].Frame;
	
	elozo=Key[0].Pos;
	for (j=1;j<NumKeys;j++) 
	{
		uj=Key[j].Pos;
		Key[j].Pos=uj%elozo;
		elozo=Key[j].Pos;
	}

	if (NumKeys>1)
		for (j=0;j<NumKeys;j++) 
		{
			Key[j].an=getq(an,j,RotLock & 3);
			Key[j].bn=getq(bn,j,RotLock & 3);
		}

}


Quaternion AEROTTRACK::Bezier(Quaternion &qn,Quaternion &qn1, 
							  Quaternion &bn,Quaternion &an1, float t) 
{

	Quaternion q0,q1,q2;

	q0 = Slerp(qn,bn,t);
    q1 = Slerp(bn,an1,t);
    q2 = Slerp(an1,qn1,t);

    q0 = Slerp(q0,q1,t);
    q1 = Slerp(q1,q2,t);

    return(Slerp(q0,q1,t));
}



Matrix AEROTTRACK::Evaluate(float time)	
{
	int		i,Frames;
	float	t;
	Matrix	m;
	int     rmode;

	rmode=RotLock & 3;
	if (rmode!=0 && NumKeys>0) time = (float)fmod(time,Key[LastKey].Frame-Key[0].Frame)+Key[0].Frame;

	if ((NumKeys>0) && (Key[CurrKey].Frame>time)) CurrKey=0;

	for (i=CurrKey;i<NumKeys;i++) if (Key[i].Frame>time) break; i--;
	CurrKey=i;

	if ((NumKeys>1) && (i<LastKey) && (time>=Key[0].Frame)) 
	{
		Frames=Key[i+1].Frame-Key[i].Frame;
		t = (time-Key[i].Frame)/(float)Frames;
		t = Key[i].Ease(t,Key[i].EaseFrom,Key[i+1].EaseTo);
		return(Bezier(Key[i].Pos,Key[i+1].Pos,Key[i].bn,Key[i+1].an,t).ConvertToMatrix());
	} 
	else return(Key[i].Pos.ConvertToMatrix());
	
}
