#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <math.h>
#include <malloc.h>

#include "..\h\Vector.h"
#include "..\h\Wector.h"
#include "..\h\Matrix.h"
#include "..\h\Quat.h"
#include "..\h\AE3DS.h"
#include "..\h\Chunks.h"
#include "..\h\console.h"

void AE3DS::ChunkReader (long p);

void AE3DS::ASCIIZReader (AESTRING &ch) 
{
	char	temp[80];
	char	a=' ';
	int		i=0;

	while ( (a!='\0') && (i<79) )
	{
		a=fgetc(File);
		temp[i++]=a;
	}
	ch= new char[i];
	strcpy(ch,temp);
}

int  AE3DS::FindMap(AESTRING mit) 
{
	int i;
	i=0;
	while ((i<CurrMap) && strcmp(mit,Map[i]->File)) i++;

	if (i<CurrMap) return(i);
	else {
		Map[i]=new AEMAP;
		Map[i]->File=new char[strlen(mit)+1];
		Map[i]->Num=i;
		strcpy(Map[i]->File,mit);
		CurrMap++;
		return(-1);
    }
}

int  AE3DS::FindMaterial(AESTRING mit) 
{
	int i;
	i=0;
	while (strcmp(mit,Mat[i]->Name) && (i<CurrMat)) i++;
	return(i);
}

void AE3DS::PercentBReader(long p)
{
	fread(&PercentBLoad,sizeof(PercentBLoad),1,File);
	PercentFLoad=(float)PercentBLoad;
}

void AE3DS::PercentFReader(long p)
{
	fread(&PercentFLoad,sizeof(PercentFLoad),1,File);
	PercentBLoad=(int)(PercentFLoad*256);
}


void AE3DS::ColorFReader(long p)
{
	fread(&FColLoad,sizeof(FCol),3,File);
	BColLoad[0]=(char)(FColLoad.r*256.f);
	BColLoad[1]=(char)(FColLoad.g*256.f);
	BColLoad[2]=(char)(FColLoad.b*256.f);
}

void AE3DS::ColorBReader(long p)
{
	fread(BColLoad,sizeof(char),3,File);
	FColLoad.r=(float)BColLoad[0]/256.f;
	FColLoad.g=(float)BColLoad[1]/256.f;
	FColLoad.b=(float)BColLoad[2]/256.f;
}

void AE3DS::ObjBlockReader (long p) 
{
	ASCIIZReader(ObjName);
	//printf("Reading object block %s\n",World[CurrObj]->Name);
	ChunkReader(p);

	World[CurrObj]->Name= ObjName;
//	World[CurrObj]->Name= new char[strlen(ObjName)+1];
//	strcpy(World[CurrObj]->Name,ObjName);
//	delete ObjName;
	CurrObj++;
}

void AE3DS::AmbientBlockReader (long p)
{
	fseek(File,6,SEEK_CUR);  //szinek mindig a kovetkezo chunkban vannak
	fread(&(Ambient->Col),sizeof(FCol), 1,File);

	World[CurrObj]=new AEAMBIENT;
	World[CurrObj]->Name="$AMBIENT$";
	World[CurrObj]->Type=AMBIENT;
	CurrObj++;
}


void AE3DS::TriMeshReader (long p)
{
	World[CurrObj]= new AETRIMESH;
	World[CurrObj]->Type= TRIMESH;
	Trimesh[CurrTrimesh]=(AETRIMESH*)(World[CurrObj]);

	ChunkReader(p);

	AETRIMESH *tmesh=Trimesh[CurrTrimesh];
	// mapping coordinatak atmasolasa facekbe
	if (tmesh->NumMapped) {
		for (int j=0;j<tmesh->NumFaces;j++) {
			tmesh->Faces[j].MapCoords[0]=tmesh->MapCoords[tmesh->Faces[j].a];
			tmesh->Faces[j].MapCoords[1]=tmesh->MapCoords[tmesh->Faces[j].b];
			tmesh->Faces[j].MapCoords[2]=tmesh->MapCoords[tmesh->Faces[j].c];
		}
	}

	CurrTrimesh++;
}

void AE3DS::VertListReader (long p)
{
	word nv;
	Vector v;

    fread(&nv, sizeof(nv), 1,File);
	Trimesh[CurrTrimesh]->NumVert=nv;

	Trimesh[CurrTrimesh]->Normals= new Vector[nv];
    Trimesh[CurrTrimesh]->Vertices= new Vector[nv];

	for (int i=0;i<nv;i++)
	{
		fread(&v,sizeof(Vector),1,File);
		Trimesh[CurrTrimesh]->Vertices[i].x=v.x;
		Trimesh[CurrTrimesh]->Vertices[i].y=v.z;
		Trimesh[CurrTrimesh]->Vertices[i].z=v.y;
	}
}

void AE3DS::FaceListReader (long p) 
{
	word nv,i,t[4];

	fread(&nv, sizeof(nv), 1,File);
	Trimesh[CurrTrimesh]->NumFaces=nv;

	Trimesh[CurrTrimesh]->Faces= new AEFACE[nv];

    for (i=0;i<nv;i++) 
	{
		fread(&t,sizeof(word),4,File);
		Trimesh[CurrTrimesh]->Faces[i].a=t[0];
		Trimesh[CurrTrimesh]->Faces[i].b=t[1];
		Trimesh[CurrTrimesh]->Faces[i].c=t[2];
		Trimesh[CurrTrimesh]->Faces[i].Edges=t[3];
   }
   ChunkReader(p);
}

void AE3DS::FaceMatReader (long p) 
{
	word n, nf;
	int i;
	AESTRING ch;

	ASCIIZReader(ch);
	i=FindMaterial(ch);
	delete ch;
	Trimesh[CurrTrimesh]->Material=Mat[i];

    fread(&n, sizeof(n), 1,File);
	while (n-- > 0)
	{
		fread(&nf, sizeof(nf), 1,File);
		Trimesh[CurrTrimesh]->Faces[nf].Material=Mat[i];
	}
}

void AE3DS::MapListReader (long p) 
{ //csak annyit tolt be ahany Mappolva van
	word nv;

	fread(&nv, sizeof(nv), 1,File);

	Trimesh[CurrTrimesh]->NumMapped=nv;
	Trimesh[CurrTrimesh]->MapCoords= new FUV[nv];

	fread(Trimesh[CurrTrimesh]->MapCoords,sizeof(FUV),nv,File);
	for (int i=0;i<nv;i++) Trimesh[CurrTrimesh]->MapCoords[i].v*=-1;
}

void AE3DS::SmooListReader (long p)
{
	int	Smooth,i;

	for (i=0;i<Trimesh[CurrTrimesh]->NumFaces;i++) {
		fread(&Smooth, sizeof(Smooth), 1, File);
		Trimesh[CurrTrimesh]->Faces[i].Smooth=Smooth;
	}
}

void AE3DS::AXPNameReader(long pc)
{
	ASCIIZReader(Trimesh[CurrTrimesh]->ProcessName);
}

void AE3DS::TrMatrixReader(long p) 
{
	Matrix tmp;
	float x;

	fread(&tmp.m[0][0],sizeof(float)*3,1,File);
	fread(&tmp.m[2][0],sizeof(float)*3,1,File);
	fread(&tmp.m[1][0],sizeof(float)*3,1,File);
	fread(&tmp.m[3][0],sizeof(float)*3,1,File);
	tmp.m[0][3]=tmp.m[1][3]=tmp.m[2][3]=0;tmp.m[3][3]=1;

	x=tmp.m[0][1];	tmp.m[0][1]=tmp.m[0][2];	tmp.m[0][2]=x;
	x=tmp.m[1][1];	tmp.m[1][1]=tmp.m[1][2];	tmp.m[1][2]=x;
	x=tmp.m[2][1];	tmp.m[2][1]=tmp.m[2][2];	tmp.m[2][2]=x;
	x=tmp.m[3][1];	tmp.m[3][1]=tmp.m[3][2];	tmp.m[3][2]=x;
	
	memcpy(&(Trimesh[CurrTrimesh]->LocMatrix),&tmp,sizeof(Matrix));
}

void AE3DS::LightReader(long p) 
{
	Vector v;

	World[CurrObj]= new AELIGHT;
	World[CurrObj]->Type= LIGHT;
	Light[CurrLight]=(AELIGHT*)(World[CurrObj]);

	fread(&v,sizeof(Vector),1,File);
	Light[CurrLight]->Pos.x=v.x;
	Light[CurrLight]->Pos.y=v.z;
	Light[CurrLight]->Pos.z=v.y;

	fseek(File,6,SEEK_CUR);  //szinek mindig a kovetkezo chunkban vannak
	fread(&(Light[CurrLight]->Col),sizeof(FCol), 1,File);

	ChunkReader(p);
	CurrLight++;
}

void AE3DS::SpotLightReader(long p) 
{
	Vector v;

	fread( &v,sizeof(Vector), 1,File);
	Light[CurrLight]->Trg.x=v.x;
	Light[CurrLight]->Trg.y=v.z;
	Light[CurrLight]->Trg.z=v.y;

	fread( &(Light[CurrLight]->Hotspot),sizeof(float), 1,File);
	fread( &(Light[CurrLight]->Falloff),sizeof(float), 1,File);
	ChunkReader(p);
}

void AE3DS::InnerRangeReader(long p) 
{
	float r;
	fread( &r,sizeof(float),1,File);
	Light[CurrLight]->InnerRange=r;
	ChunkReader(p);
}

void AE3DS::OuterRangeReader(long p) 
{
	float r;
	fread( &r,sizeof(float),1,File);
	Light[CurrLight]->OuterRange=r;
	ChunkReader(p);
}

void AE3DS::CameraReader(long p) 
{
	Vector v;

	World[CurrObj]=new AECAMERA;
	World[CurrObj]->Type= CAMERA;
	Camera[CurrCam]=(AECAMERA*)(World[CurrObj]);

	fread( &v,sizeof(Vector), 1,File);
	Camera[CurrCam]->Pos.x=v.x;
	Camera[CurrCam]->Pos.y=v.z;
	Camera[CurrCam]->Pos.z=v.y;
	fread( &v,sizeof(Vector), 1,File);
	Camera[CurrCam]->Trg.x=v.x;
	Camera[CurrCam]->Trg.y=v.z;
	Camera[CurrCam]->Trg.z=v.y;
	fread( &(Camera[CurrCam]->Roll),sizeof(float), 1,File);
	fread( &(Camera[CurrCam]->Lens),sizeof(float), 1,File);
	Camera[CurrCam]->FOV();
	CurrCam++;
	ChunkReader(p);


}

// ******************************************************
// ****                                              ****
// **             Material stuff from here             **
// ****                                              ****
// ******************************************************
void AE3DS::MatAmbientReader(long p)
{
	ChunkReader(p);
	Mat[CurrMat]->Ambient.r=FColLoad.r;
	Mat[CurrMat]->Ambient.g=FColLoad.g;
	Mat[CurrMat]->Ambient.b=FColLoad.b;

}

void AE3DS::MatDiffuseReader(long p)
{
	ChunkReader(p);
	Mat[CurrMat]->Diffuse.r=FColLoad.r;
	Mat[CurrMat]->Diffuse.g=FColLoad.g;
	Mat[CurrMat]->Diffuse.b=FColLoad.b;
}

void AE3DS::MatSpecularReader(long p)
{
	ChunkReader(p);
	Mat[CurrMat]->Specular.r=FColLoad.r;
	Mat[CurrMat]->Specular.g=FColLoad.g;
	Mat[CurrMat]->Specular.b=FColLoad.b;
}

void AE3DS::TranspReader (long p)
{
	ChunkReader(p);
	Mat[CurrMat]->Transparency=PercentFLoad;
}


void AE3DS::TexMapReader (long p) 
{
	int i;

	Mapnum=&i;
	ChunkReader(p);
	Mat[CurrMat]->TextureMap = Map[i];
}

void AE3DS::EnvMapReader (long p) 
{
	int i;

	Mapnum=&i;
	ChunkReader(p);
	Mat[CurrMat]->EnvMap = Map[i];

}

void AE3DS::MapFileReader(long p) 
{
	int i;
	AESTRING temp;

	MapLoad=&temp;
	ASCIIZReader(*MapLoad);
	i=FindMap(*MapLoad);
	delete *MapLoad;
	if (i==-1) *Mapnum=CurrMap-1;
	else *Mapnum=i;
	ChunkReader(p);
}

void AE3DS::MatNameReader (long p)
{
	Mat[CurrMat]=new AEMAT;
	ASCIIZReader(Mat[CurrMat]->Name);
}

void AE3DS::MaterialReader (long p)
{
	ChunkReader(p);
	CurrMat++;
}

// ******************************************************
// ****                                              ****
// **            Keyframing stuff from here            **
// ****                                              ****
// ******************************************************

void AE3DS::CurFrameReader (long p) 
{
	int temp;
	fread(&temp, sizeof(temp), 1,File);
	CurrFrame=(float)temp;
}

void AE3DS::FramesReader(long p) 
{
	fread(&StartFrame, sizeof(&StartFrame), 1,File);
	fread(&EndFrame, sizeof(&EndFrame), 1,File);
}

void AE3DS::ObjTrackInfoReader(long p) 
{
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=OBJECTNODE;
	ObjNode[CurrObjNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrObjNode++;
}

void AE3DS::CamTrackInfoReader(long p)
 {
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=CAMERANODE;
	CameraNode[CurrCamNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrCamNode++;
}

void AE3DS::TargetTrackInfoReader(long p) 
{
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=CTARGETNODE;
	CTargetNode[CurrCTargetNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrCTargetNode++;
}

void AE3DS::LightTrackInfoReader(long p) 
{
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=LIGHTNODE;
	LightNode[CurrLightNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrLightNode++;
}

void AE3DS::SpotlightTrackInfoReader(long p) 
{
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=SPOTLIGHTNODE;
	SpotlightNode[CurrSpotlightNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrSpotlightNode++;
}

void AE3DS::LTargetTrackInfoReader(long p) 
{
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=LTARGETNODE;
	LTargetNode[CurrLTargetNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrLTargetNode++;
}

void AE3DS::AmbientTrackInfoReader(long p) 
{
	Nodes[CurrNode]= new AENODE;
	Nodes[CurrNode]->Type=AMBIENTNODE;
	AmbientNode[CurrAmbientNode]=Nodes[CurrNode];
	ChunkReader(p);
	CurrNode++;
	CurrAmbientNode++;
}


void AE3DS::ObjNumberReader(long p) 
{  // NODE_ID
	word temp;
	fread(&temp,sizeof(word),1,File);
	Nodes[CurrNode]->ID=temp;
}

void AE3DS::TrackInstNameReader(long p)
{
	ASCIIZReader(World[CurrObj-1]->Name);

	delete Nodes[CurrNode]->Name;
	Nodes[CurrNode]->Name= new char[strlen(World[CurrObj-1]->Name)+1];
	strcpy(Nodes[CurrNode]->Name,World[CurrObj-1]->Name);
}

void AE3DS::TrackObjNameReader(long p) 
{    //NODE_HDR
	word temp[3];
	int i;

	ASCIIZReader(Nodes[CurrNode]->Name);

	fread(&temp,sizeof(word),3,File);
	Nodes[CurrNode]->Flags1=temp[0];
	Nodes[CurrNode]->Flags2=temp[1];
	Nodes[CurrNode]->Parent=temp[2];

	//printf("%s\n",Nodes[CurrNode]->Name);
	
	if (!strcmp(Nodes[CurrNode]->Name,"$$$DUMMY")) 
	{
		World[CurrObj]= new AEDUMMY;
		World[CurrObj]->Type= DUMMY;

		Nodes[CurrNode]->Obj=World[CurrObj];
		((AEDUMMY *)(World[CurrObj]))->LocMatrix.Identity();
		CurrObj++;
	}
	else {
		for (i=0;i<CurrObj;i++) {
			if (!strcmp(Nodes[CurrNode]->Name,World[i]->Name)) break;
		}
		
		Nodes[CurrNode]->Obj=World[i];
		if (World[i]->Type==TRIMESH)
		{
			//printf(" %d\n",((AETRIMESH*)(World[i]->Obj))->NumVert);
			Nodes[CurrNode]->Rotated= new AEVERTEX[((AETRIMESH*)(World[i]))->NumVert];
			Nodes[CurrNode]->RotatedNormals= new Vector[((AETRIMESH*)(World[i]))->NumVert];
		}
	}
}

void AE3DS::PivotPointReader(long p) {
	Vector v;

	fread(&v,sizeof(Vector),1,File);
	Nodes[CurrNode]->Pivot.x=v.x;
	Nodes[CurrNode]->Pivot.y=v.z;
	Nodes[CurrNode]->Pivot.z=v.y;

}

// ****************************
// **  Spline Reading Stuff  **
// ****************************
void AE3DS::SplineFlagsReader(AESPLINE *Spline) {

	Spline->Flags=0;
	fread(&Spline->Flags,sizeof(word),1,File);
	Spline->Tens=Spline->Bias=Spline->Cont=Spline->EaseTo=Spline->EaseFrom=0;

	if ((Spline->Flags & 1)!=0) fread(&Spline->Tens,sizeof(float),1,File);
    if ((Spline->Flags & 2)!=0) fread(&Spline->Cont,sizeof(float),1,File);
	if ((Spline->Flags & 4)!=0) fread(&Spline->Bias,sizeof(float),1,File);
	if ((Spline->Flags & 8)!=0) fread(&Spline->EaseTo,sizeof(float),1,File);
	if ((Spline->Flags & 16)!=0) fread(&Spline->EaseFrom,sizeof(float),1,File);

}



// ***************************
// **  Track Reading Stuff  **
// ***************************

void AE3DS::TrackPosReader(long p) {
	word tempw;
	int i,n,templ;
	Vector v;
    
	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->PosTrack.Lock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->PosTrack.NumKeys=n;
	Nodes[CurrNode]->PosTrack.Key= new AEKEY<Vector>[n];

	for (i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->PosTrack.Key[i].Frame= templ;
		SplineFlagsReader(&Nodes[CurrNode]->PosTrack.Key[i]);
		fread(&v,sizeof(Vector),1,File);
		Nodes[CurrNode]->PosTrack.Key[i].val.x=v.x;
		Nodes[CurrNode]->PosTrack.Key[i].val.y=v.z;
		Nodes[CurrNode]->PosTrack.Key[i].val.z=v.y;
	}
}

void AE3DS::TrackRotReader(long p) {
	word tempw;
	int i,n,templ;
	Vector v;
	Quaternion *q;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->RotTrack.RotLock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->RotTrack.NumKeys= n;
	Nodes[CurrNode]->RotTrack.Key= new AEROTKEY[n];

	for (i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->RotTrack.Key[i].Frame= templ;
		SplineFlagsReader(&Nodes[CurrNode]->RotTrack.Key[i]);
		
		q=&(Nodes[CurrNode]->RotTrack.Key[i].AngleAxis);
		fread(&(q->Angle),sizeof(float),1,File);
		fread(&v,sizeof(Vector),1,File);
		q->Axis.x=v.x;
		q->Axis.y=v.z;
		q->Axis.z=v.y;

		Nodes[CurrNode]->RotTrack.Key[i].Pos.Convert(q->Angle,q->Axis);
		Nodes[CurrNode]->RotTrack.Key[i].Pos.Normalize();
	}
}

void AE3DS::TrackScaleReader(long p) {
	word tempw;
	int i,n,templ;
	Vector v;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->ScaleTrack.Lock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->ScaleTrack.NumKeys=n;
	Nodes[CurrNode]->ScaleTrack.Key= new AEKEY<Vector>[n];

	for (i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->ScaleTrack.Key[i].Frame=templ;
		SplineFlagsReader(&Nodes[CurrNode]->ScaleTrack.Key[i]);
		fread(&v,sizeof(Vector),1,File);
		Nodes[CurrNode]->ScaleTrack.Key[i].val.x=v.x;
		Nodes[CurrNode]->ScaleTrack.Key[i].val.y=v.z;
		Nodes[CurrNode]->ScaleTrack.Key[i].val.z=v.y;
	}
}

void AE3DS::TrackFovReader(long p) {
	word tempw;
	int i,n,templ;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->FovTrack.Lock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->FovTrack.NumKeys= n;
	Nodes[CurrNode]->FovTrack.Key=  new AEKEY<float>[n];
	for(i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->FovTrack.Key[i].Frame=templ;
		SplineFlagsReader(&Nodes[CurrNode]->FovTrack.Key[i]);
		fread(&Nodes[CurrNode]->FovTrack.Key[i].val,sizeof(float),1,File);
	}
}

void AE3DS::TrackRollReader(long p) {
	word tempw;
	int i,n,templ;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->RollTrack.Lock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->RollTrack.NumKeys=n;
	Nodes[CurrNode]->RollTrack.Key=  new AEKEY<float>[n];
	
	for(i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->RollTrack.Key[i].Frame=templ;
		SplineFlagsReader(&Nodes[CurrNode]->RollTrack.Key[i]);
		fread(&Nodes[CurrNode]->RollTrack.Key[i].val,sizeof(float),1,File);
	}
}

void AE3DS::TrackColorReader(long p) {
	word tempw;
	int i,n,templ;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->ColTrack.Lock=tempw;
	for(i=0; i<2; i++)
		fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->ColTrack.NumKeys= n;
	Nodes[CurrNode]->ColTrack.Key=  new AEKEY<FCol>[n];

	for (i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->ColTrack.Key[i].Frame=templ;

		SplineFlagsReader(&Nodes[CurrNode]->ColTrack.Key[i]);
		fread(&Nodes[CurrNode]->ColTrack.Key[i].val,sizeof(FCol),1,File);
	}
}


void AE3DS::TrackHideReader(long p) {
	word n,temp;
	word unknown;
	int i;

	for(i=0; i<5; i++) fread(&unknown, sizeof(unknown), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->HideTrack.NumKeys=n;
	Nodes[CurrNode]->HideTrack.Key=  new AEHIDEKEY[n];
	fread(&unknown, sizeof(unknown), 1,File);
	for (i=0;i<n;i++){
		fread(&temp,sizeof(word),1,File);
		Nodes[CurrNode]->HideTrack.Key[i].Frame=temp;
		fread(&unknown, sizeof(unknown), 1,File);
		fread(&unknown, sizeof(unknown), 1,File);
	}
}

void AE3DS::TrackHotspotReader(long p) {
	word tempw;
	int i,n,templ;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->HotspotTrack.Lock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->HotspotTrack.NumKeys= n;
	Nodes[CurrNode]->HotspotTrack.Key=  new AEKEY<float>[n];

	for(i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->HotspotTrack.Key[i].Frame=templ;
		SplineFlagsReader(&Nodes[CurrNode]->HotspotTrack.Key[i]);
		fread(&Nodes[CurrNode]->HotspotTrack.Key[i].val,sizeof(float),1,File);
	}
}

void AE3DS::TrackFalloffReader(long p) {
	word tempw;
	int i,n,templ;

	fread(&tempw, sizeof(tempw), 1,File);
	Nodes[CurrNode]->FalloffTrack.Lock=tempw;
	for(i=0; i<2; i++) fread(&templ, sizeof(templ), 1,File);
	fread(&n, sizeof(n), 1,File);
	Nodes[CurrNode]->FalloffTrack.NumKeys= n;
	Nodes[CurrNode]->FalloffTrack.Key=  new AEKEY<float>[n];

	for(i=0;i<n;i++){
		fread(&templ,sizeof(templ),1,File);
		Nodes[CurrNode]->FalloffTrack.Key[i].Frame=templ;
		SplineFlagsReader(&Nodes[CurrNode]->FalloffTrack.Key[i]);
		fread(&Nodes[CurrNode]->FalloffTrack.Key[i].val,sizeof(float),1,File);
	}
}

// ******************************************************
// ****                                              ****
// **             Main procedures from here            **
// ****                                              ****
// ******************************************************

void AE3DS::ChunkReader(long p) {
	TChunkHeader h;
	long pc;

	while (ftell(File) < p) {
		pc = ftell(File);
		fread(&h.ID, sizeof(h.ID), 1,File);
		fread(&h.len, sizeof(h.len), 1,File);

		if (h.len == 0) return;
		pc += h.len;

		switch(h.ID)
		{
		case	CHUNK_MAIN:		ChunkReader(pc);		break;
		
		case	CHUNK_RGBF:		ColorFReader(pc);		break;
		case	CHUNK_RGBB:		ColorBReader(pc);		break;
		case	CHUNK_PERCB:	PercentBReader(pc);		break;
		case	CHUNK_PERCF:	PercentFReader(pc);		break;
		case	CHUNK_AMBCOLOR:	AmbientBlockReader(pc);	break;

		case	CHUNK_OBJMESH:	ChunkReader(pc);		break;

		case	CHUNK_OBJBLOCK:	ObjBlockReader(pc);		break;
		case	CHUNK_TRIMESH:	TriMeshReader(pc);		break;
		case	CHUNK_VERTLIST:	VertListReader(pc);		break;
		case	CHUNK_FACELIST:	FaceListReader(pc);		break;
		case	CHUNK_FACEMAT:	FaceMatReader(pc);		break;
		case	CHUNK_MAPLIST:	MapListReader(pc);		break;
		case	CHUNK_SMOOLIST: SmooListReader(pc);		break;
		case	CHUNK_TXTINFO:							break;
		case	CHUNK_TRMATRIX:	TrMatrixReader(pc);		break;
		case	CHUNK_AXPNAME:	AXPNameReader(pc);		break;
		
		case	CHUNK_LIGHT:	LightReader(pc);		break;
		case	CHUNK_SPOTLIGHT:SpotLightReader(pc);	break;
		case	CHUNK_INNERRANGE:InnerRangeReader(pc);	break;		
		case	CHUNK_OUTERRANGE:OuterRangeReader(pc);	break;	
			
		case	CHUNK_CAMERA:	CameraReader(pc);		break;

		case	CHUNK_MATERIAL:		MaterialReader(pc);		break;
		case	CHUNK_MATNAME:		MatNameReader(pc);		break;
		case	CHUNK_MATAMBIENT:	MatAmbientReader(pc);	break;
		case	CHUNK_MATDIFFUSE:	MatDiffuseReader(pc);	break;
		case	CHUNK_MATSPECULAR:	MatSpecularReader(pc);	break;
		case	CHUNK_TEXTURE:		TexMapReader(pc);		break;
		case	CHUNK_ENVMAP:		EnvMapReader(pc);		break;
		case	CHUNK_TRANSPARENCY:	TranspReader(pc);		break;
		case	CHUNK_MAPFILE:		MapFileReader(pc);		break;

		case	CHUNK_KEYFRAMER:	ChunkReader(pc);				break;
		case	CHUNK_FRAMES:		FramesReader(pc);				break;
		case	CHUNK_AMBIENTKEY:	AmbientTrackInfoReader(pc);		break;
		case	CHUNK_TRACKOBJECT:	ObjTrackInfoReader(pc);			break;
		case	CHUNK_TRACKCAMERA:	CamTrackInfoReader(pc);			break;
		case	CHUNK_TRACKCAMTGT:	TargetTrackInfoReader(pc);		break;
		case	CHUNK_TRACKLIGHT:	LightTrackInfoReader(pc);		break;
		case	CHUNK_TRACKLIGTGT:	LTargetTrackInfoReader(pc);		break;
		case	CHUNK_TRACKSPOTL:	SpotlightTrackInfoReader(pc);	break;
		case	CHUNK_TRACKOBJNAME:	TrackObjNameReader(pc);			break;
		case	CHUNK_TRACKINSTNAME:TrackInstNameReader(pc);		break;
		case	CHUNK_TRACKPIVOT:	PivotPointReader(pc);			break;
		case	CHUNK_TRACKPOS:		TrackPosReader(pc);				break;
		case	CHUNK_TRACKROTATE:	TrackRotReader(pc);				break;
		case	CHUNK_TRACKSCALE:	TrackScaleReader(pc);			break;
		case	CHUNK_TRACKFOV:		TrackFovReader(pc);				break;
		case	CHUNK_TRACKROLL:	TrackRollReader(pc);			break;
		case	CHUNK_TRACKCOLOR:	TrackColorReader(pc);			break;
		case	CHUNK_TRACKHOTSPOT:	TrackHotspotReader(pc);			break;
		case	CHUNK_TRACKFALLOFF:	TrackFalloffReader(pc);			break;
		case	CHUNK_TRACKHIDE:	TrackHideReader(pc);			break;
		case	CHUNK_OBJNUMBER:	ObjNumberReader(pc);			break;
		}
		fseek(File, pc, SEEK_SET);
	}
}

int AE3DS::Load3ds() {
	long p;
	int res;

	res=Scan3ds();

	if (res!=0) return res;

	CurrNode=CurrObj=CurrCam=CurrTrimesh=CurrLight=CurrAmbient=0;
	CurrMat=CurrMap=0;
	CurrObjNode=CurrCamNode=CurrCTargetNode=CurrSpotlightNode=CurrLightNode=CurrLTargetNode=0;
	CurrAmbientNode=0;

	Mat=new AEMAT* [NumMats];
	Map=new AEMAP* [NumMaps];
	GlowMap=new AEMAP;

	World=new AEOBJECT* [NumObjs];
	Camera=new AECAMERA* [NumCams];
	Trimesh=new AETRIMESH* [NumTrimeshes];
	Light=new AELIGHT* [NumLights];

	Nodes=new AENODE* [NumNodes];
	ObjNode=new AENODE* [NumObjNodes];
	CameraNode=new AENODE* [NumCamNodes];
	CTargetNode=new AENODE* [NumCTargetNodes];
	LightNode=new AENODE* [NumLightNodes];
	LTargetNode=new AENODE* [NumLTargetNodes];
	SpotlightNode=new AENODE* [NumSpotlightNodes];
	AmbientNode=new AENODE* [NumAmbientNodes];

	File=fopen(FileName,"rb");

	fseek(File, 0, SEEK_END);
	p = ftell(File);
	fseek(File, 0, SEEK_SET);
	ChunkReader( p);
	fclose(File);
	
	if (CurrMap!=NumMaps) NumMaps=CurrMap;
	if (
		(CurrMat!=NumMats) ||

		(CurrObj!=NumObjs) ||
		(CurrCam!=NumCams) ||
		(CurrTrimesh!=NumTrimeshes) ||
		(CurrLight!=NumLights) ||

		(CurrNode!=NumNodes) ||
		(CurrObjNode!=NumObjNodes) ||
		(CurrCamNode!=NumCamNodes) ||
		(CurrCTargetNode!=NumCTargetNodes) ||
		(CurrLightNode!=NumLightNodes) ||
		(CurrLTargetNode!=NumLTargetNodes) ||
		(CurrSpotlightNode!=NumSpotlightNodes) ||
		(CurrAmbientNode!=NumAmbientNodes))
	{
		return(-1);// INTERNAL ERROR
	}

	// 3DS SPECIAL INITIALIZATIONS
	for (int i=0;i<NumNodes;i++)
	{
		if (Nodes[i]->Obj) {
			if ((Nodes[i]->Obj)->Type==TRIMESH) // transform mesh vertices back to local space
			{
				AETRIMESH *tmesh;
				
				tmesh=(AETRIMESH *)Nodes[i]->Obj;

				Vector Col1(tmesh->LocMatrix.m[0][0],tmesh->LocMatrix.m[1][0],tmesh->LocMatrix.m[2][0]);
				Vector Col2(tmesh->LocMatrix.m[0][1],tmesh->LocMatrix.m[1][1],tmesh->LocMatrix.m[2][1]);
				Vector Col3(tmesh->LocMatrix.m[0][2],tmesh->LocMatrix.m[1][2],tmesh->LocMatrix.m[2][2]);
				bool FlipX; FlipX=false;
				if (((Col1%Col2)*Col3)<0) FlipX=true; // workaround

				Matrix transform,translate;

				translate.Translate(-Vector(tmesh->LocMatrix.m[3][0],tmesh->LocMatrix.m[3][1],tmesh->LocMatrix.m[3][2]));

				Matrix t;
				t=tmesh->LocMatrix;

				transform=t.Invert();
				transform.Location(-Nodes[i]->Pivot);
				transform.m[3][3]=1;
				transform=translate*transform;

				for(int j=0;j<tmesh->NumVert;j++) {
					tmesh->Vertices[j]=transform*tmesh->Vertices[j];
					if (FlipX) tmesh->Vertices[j].x*=-1;
				}
			}
		}
	}

	BuildTree(&Eve); // builds a parent/child corelation tree
	return(0);
}

