#ifndef _AEKEYFRAMING_
#define _AEKEYFRAMING_

#include "Vector.h"
#include "Wector.h"
#include "Matrix.h"
#include "Quat.h"
#include "Fcol.h"

#include <assert.h>
#include "console.h"
#include <malloc.h>
#include <memory.h>

class Rotation {
public:
	Quaternion	Quat;
	Quaternion	AngleAxis;
	Quaternion	Pos;
};

class AESPLINE {
public:
	int		Flags;
	float	Tens,Bias,Cont;
	float	EaseTo,EaseFrom;

	float	Ease(float t,float a,float b);

	AESPLINE() { Tens=0,Bias=0,Cont=0,EaseTo=0,EaseFrom=0; }
};

//**********************
//*+------------------+*
//*| Keyframing stuff |*
//*+------------------+*
//**********************

enum NODETYPE {
	OBJECTNODE=1,
	CAMERANODE,	CTARGETNODE,
	LIGHTNODE,	LTARGETNODE,	SPOTLIGHTNODE,
	AMBIENTNODE
};

//*****************
//*+-------------+*
//*|  Key types  |*
//*+-------------+*
//*****************
class AEROTKEY:public AESPLINE {
public:
    int Frame;
	Quaternion AngleAxis;
	Quaternion Pos;
	Quaternion an,bn;
};


template <class T> class AEKEY:public AESPLINE {
public:
    int Frame;

    T val;
    T an, bn;

};

class AEHIDEKEY	{
public:
	int Frame;
};


//*******************
//*+---------------+*
//*|  Track Types  |*
//*+---------------+*
//*******************
class AEHIDETRACK {
public:
	int			NumKeys,LastKey,LastFrame;
	AEHIDEKEY	*Key;
	
	void Init(void)	{
		LastKey=NumKeys-1;
		LastFrame = Key[LastKey].Frame;
	}
	bool GetStatus(float frame)	{
		int i;

		if (NumKeys==0) return 0;
	
		for (i=0;i<NumKeys;i++) if (Key[i].Frame>frame) break;
		return i&1;
	}
};

class AEROTTRACK {
public:
	int			NumKeys,LastKey,LastFrame,CurrKey;
	AEROTKEY	*Key;
	int			RotLock;
	
	Matrix		Evaluate(float t);
    void		Init(void);
	Quaternion	getq(int sel, int n, int mode);
	Quaternion	Slerp(Quaternion &q1, Quaternion &q2, float t);
	Quaternion	Bezier(Quaternion &qn,Quaternion &qn1, 
					  Quaternion &bn,Quaternion &an1, float t);
};

//***********************
//*+-------------------+*
//*|  Track Functions  |*
//*+-------------------+*
//***********************

template <class T> class AETRACK {
public:
    enum FLAGS { LOOP = 1,REPEAT=2 };
    int NumKeys,LastKey,LastFrame,CurrKey;
//    FLAGS Flags;
	int Lock;

    AEKEY<T> *Key;

    T Evaluate(float t);
    void Init(void);
	T getv(int sel, int n, int mode);
};


enum {an,bn,point};

template <class T> T AETRACK<T>::getv(int sel, int n, int mode) {
	AEKEY<T> *kn_1, *kn, *kn1;
	T *pn_1, *pn, *pn1,out;
	float d1, d2;

	kn = &Key[n];
	pn = &kn->val;

	if (sel == point) return *pn;

	if (n == 0) 
	{
		kn1 = &Key[1];
		pn1 = &kn1->val;

		if (NumKeys == 2) 
		{
			out =(*pn1 - *pn)*(1.0f - kn->Tens);
			return out;
		}
		if (mode != 3) 
		{ //first key, no loop
			out = ((*pn1 - *pn)*1.5f - getv(an,1,mode)*0.5f);
			out *=(1.0f - kn->Tens);
			return out;
		} 
		else 
		{ //first key, loop
			kn_1= &Key[NumKeys-2];
			d1 = (float)Key[NumKeys-1].Frame - (float)kn_1->Frame;
			d2 = (float)kn1->Frame - (float)kn->Frame;
		}
	} 
	else if (n == LastKey) 
	{
		kn_1 = &Key[n-1];
		pn_1 = &kn_1->val;

		if (NumKeys == 2) 
		{
			out = (*pn - *pn_1);
			out *=(1.0f - kn->Tens);
			return out;
		}
		if (mode != 3) 
		{//last key, no loop
			out = ((*pn - *pn_1)*1.5f - getv(bn,n-1,mode)*0.5f);
			out *=(1.0f - kn->Tens);
			return out;
		} 
		else 
		{//last key, loop
			kn1 = &Key[1];
			d1 = (float)kn->Frame - (float)kn_1->Frame;
			d2 = (float)kn1->Frame - (float)Key[0].Frame;
		}
	} 
	else//middle keys 
	{
		kn_1= &Key[n-1];
		kn1 = &Key[n+1];
		d1 = (float)kn->Frame - (float)kn_1->Frame;
		d2 = (float)kn1->Frame - (float)kn->Frame;
	}
	pn_1= &kn_1->val;
	pn1 = &kn1->val;

	float C;
	float adjust;

	if (sel == an) 
	{
		C = kn->Cont;
		adjust = d1;
	}
	else 
	{
		C = -(kn->Cont);
		adjust = d2;
	}
	adjust /= d1 + d2;
	adjust = 0.5f + (1.0f - (float)fabs(C))*(adjust - 0.5f);

	out = (*pn  - *pn_1) * ((1.0f + kn->Bias)*(1.0f - C));
	out+= (*pn1 - *pn  ) * ((1.0f - kn->Bias)*(1.0f + C));
	out*= (1.0f - kn->Tens)*adjust;
	return out;
}


template <class T> void AETRACK<T>::Init(void) {
	int j;

	CurrKey=0;
	LastKey=NumKeys-1;
    LastFrame = Key[LastKey].Frame;
    
	if (NumKeys>1)
		for (j=0;j<NumKeys;j++) 
		{
			Key[j].an=getv(an,j,Lock & 3);
			Key[j].bn=getv(bn,j,Lock & 3);
		}
}


template <class T> T AETRACK<T>::Evaluate(float time) {
    T out;
	int i;
	float Frames;
	float h[4],t,t2,t3;


	if (((Lock & 3)!=0) && (NumKeys>0)) time=(float)fmod(time,Key[LastKey].Frame-Key[0].Frame)+Key[0].Frame;

	if ((NumKeys==1) || (time<=Key[0].Frame)) return (Key[0].val);
	
	if ((NumKeys>0) && (Key[CurrKey].Frame>time)) CurrKey=0;

	for (i=CurrKey;i<NumKeys;i++) if (Key[i].Frame>time) break; i--;
	CurrKey=i;

	if (i==LastKey) return (Key[LastKey].val);

	Frames = (float)Key[i+1].Frame - (float)Key[i].Frame;
	t = (time-Key[i].Frame)/Frames;

	t = Key[i].Ease( t,Key[i].EaseFrom,Key[i+1].EaseTo );
	t2 = t*t;
	t3 = t2*t;
	h[0] = 2*t3 - 3*t2 + 1;
	h[1] = -2*t3 + 3*t2;
	h[2] = t3 - 2*t2 + t;
	h[3] = t3 - t2;

	out  = (Key[i].val*h[0])+ (Key[i+1].val*h[1]) + (Key[i].bn*h[2]) + (Key[i+1].an*h[3]);

    //out  = Key[i].val*h[0]+Key[i+1].val*h[1]+Key[i].bn*h[2]+Key[i+1].an*h[3];

	return out;
}


//*********************
//*+-----------------+*
//*| Node Definition |*
//*+-----------------+*
//*********************


class AENODE {
private:
	float		TempNearPlane, TempFarPlane;

public:
	int			ID;
	AESTRING	Name;
	AEOBJECT	*Obj;
	int			Stamp;

	NODETYPE	Type;
	Matrix		LocalToWorld;
	Matrix		LocalToCamera;
	Matrix		LocalToScreen;
	Matrix		WorldToLocal;
	Vector		InverseCamPos;
	bool		Hidden;
	bool		Shaded;
	bool		LightDistanceCounts;
	bool		FogEnabled;
	bool		MasterColor;
	bool		PostColor;
	bool		LightMapped;
	bool		DoubleMapped;
	bool		WireFrame;
	FCol		MCol;
	int			Flags1,Flags2,Parent;
	int			ClipPlaneAND,ClipPlaneOR;
	AEVERTEX	*Rotated;
	Vector		*RotatedNormals;
	FCol		*PostColors;
	Vector		Pivot;
	AEFILLER	*swfiller;
	AENODE		*FirstDaughter, *PrevSister, *NextSister;

	AETRACK<Vector>		ScaleTrack;
	AETRACK<Vector>		PosTrack;
	AEROTTRACK			RotTrack;
	AETRACK<FCol>		ColTrack;
	AETRACK<float>		RollTrack;
	AETRACK<float>		FovTrack;
	AETRACK<float>		FalloffTrack;
	AETRACK<float>		HotspotTrack;
	AEHIDETRACK			HideTrack;
	
	AENODE();
	~AENODE();
	void	Render(AECAMERA *ActiveCamera,AEAMBIENT *Ambient, AELIGHT **Light, int NumLights, int StampNum);
	void	Rotate();
	void	Shade(AEAMBIENT *Ambient, AELIGHT **Light, int NumLights);
	void	RotateVertex(AEVERTEX *Vertex, int Num, AETRIMESH *Source);
	bool	CheckBBox();
	void	DrawGlow();
	void	Draw();
	void	Clip(int& NumVert,AEVERTEX *Vertices,AEVERTEX *Poly,int CLIPFLAG,int& FLAGSOR);
	void	Intersect(AEVERTEX *v,AEVERTEX *v1,AEVERTEX *v2,int CLIPFLAG,int& FLAGSOR);

};

#endif
