#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

#include "..\h\wector.h"
#include "..\h\matrix.h"
#include "..\h\console.h"

void Matrix::Identity() 
{
	m[0][1]=m[0][2]=m[0][3]=0;
	m[1][0]=m[1][2]=m[1][3]=0;
	m[2][0]=m[2][1]=m[2][3]=0;
	m[3][0]=m[3][1]=m[3][2]=0;
	m[0][0]=m[1][1]=m[2][2]=m[3][3]=1;
}
/*
void Matrix::Invert()
{
	Matrix temp;
	float len0,len1,len2;

	memcpy(temp.m,m,sizeof(float)*4*4);

	len0=(float)1./(float)(	temp.m[0][0]*temp.m[0][0]+
							temp.m[0][1]*temp.m[0][1]+
							temp.m[0][2]*temp.m[0][2]);
	len1=(float)1./(float)(	temp.m[1][0]*temp.m[1][0]+
							temp.m[1][1]*temp.m[1][1]+
							temp.m[1][2]*temp.m[1][2]);
	len2=(float)1./(float)(	temp.m[2][0]*temp.m[2][0]+
							temp.m[2][1]*temp.m[2][1]+
							temp.m[2][2]*temp.m[2][2]);

	temp.m[0][0]*=len0;	temp.m[0][1]*=len0;	temp.m[0][2]*=len0;
	temp.m[1][0]*=len1;	temp.m[1][1]*=len1;	temp.m[1][2]*=len1;
	temp.m[2][0]*=len2;	temp.m[2][1]*=len2;	temp.m[2][2]*=len2;


	m[0][0]=temp.m[0][0];
	m[0][1]=temp.m[1][0];
	m[0][2]=temp.m[2][0];
	m[0][3]=0;
	m[1][0]=temp.m[0][1];
	m[1][1]=temp.m[1][1];
	m[1][2]=temp.m[2][1];
	m[1][3]=0;
	m[2][0]=temp.m[0][2];
	m[2][1]=temp.m[1][2];
	m[2][2]=temp.m[2][2];
	m[2][3]=0;
	m[3][0]=-(temp.m[3][0]*temp.m[0][0]+
		      temp.m[3][1]*temp.m[0][1]+
			  temp.m[3][2]*temp.m[0][2]);
	m[3][1]=-(temp.m[3][0]*temp.m[1][0]+
		      temp.m[3][1]*temp.m[1][1]+
			  temp.m[3][2]*temp.m[1][2]);
	m[3][2]=-(temp.m[3][0]*temp.m[2][0]+
		      temp.m[3][1]*temp.m[2][1]+
			  temp.m[3][2]*temp.m[2][2]);
	m[3][3]=1;

}
*/

void Matrix::printf() 
{
	::conprintf("%f %f %f %f\n",m[0][0],m[0][1],m[0][2],m[0][3]);
	::conprintf("%f %f %f %f\n",m[1][0],m[1][1],m[1][2],m[1][3]);
	::conprintf("%f %f %f %f\n",m[2][0],m[2][1],m[2][2],m[2][3]);
	::conprintf("%f %f %f %f\n\n",m[3][0],m[3][1],m[3][2],m[3][3]);
}


Matrix Matrix::operator+(const Matrix &a) 
{
	Matrix s;
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			s.m[i][j]=m[i][j]+a.m[i][j];
		return(s);
}

Matrix Matrix::operator-(const Matrix &a) 
{
	Matrix s;
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			s.m[i][j]=m[i][j]-a.m[i][j];
		return(s);
}

Matrix Matrix::operator*(const Matrix &a) 
{
	Matrix s;
/*
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			s.m[i][j]=	m[i][0]*a.m[0][j]+
						m[i][1]*a.m[1][j]+
						m[i][2]*a.m[2][j]+	
						m[i][3]*a.m[3][j];
	
	*/
	s.m[0][0]=m[0][0]*a.m[0][0]+m[0][1]*a.m[1][0]+m[0][2]*a.m[2][0];//+m[0][3]*a.m[3][0];
	s.m[0][1]=m[0][0]*a.m[0][1]+m[0][1]*a.m[1][1]+m[0][2]*a.m[2][1];//+m[0][3]*a.m[3][1];
	s.m[0][2]=m[0][0]*a.m[0][2]+m[0][1]*a.m[1][2]+m[0][2]*a.m[2][2];//+m[0][3]*a.m[3][2];
	s.m[0][3]=m[0][0]*a.m[0][3]+m[0][1]*a.m[1][3]+m[0][2]*a.m[2][3];//+m[0][3]*a.m[3][3];

	s.m[1][0]=m[1][0]*a.m[0][0]+m[1][1]*a.m[1][0]+m[1][2]*a.m[2][0];//+m[1][3]*a.m[3][0];
	s.m[1][1]=m[1][0]*a.m[0][1]+m[1][1]*a.m[1][1]+m[1][2]*a.m[2][1];//+m[1][3]*a.m[3][1];
	s.m[1][2]=m[1][0]*a.m[0][2]+m[1][1]*a.m[1][2]+m[1][2]*a.m[2][2];//+m[1][3]*a.m[3][2];
	s.m[1][3]=m[1][0]*a.m[0][3]+m[1][1]*a.m[1][3]+m[1][2]*a.m[2][3];///+m[1][3]*a.m[3][3];

	s.m[2][0]=m[2][0]*a.m[0][0]+m[2][1]*a.m[1][0]+m[2][2]*a.m[2][0];//+m[2][3]*a.m[3][0];
	s.m[2][1]=m[2][0]*a.m[0][1]+m[2][1]*a.m[1][1]+m[2][2]*a.m[2][1];//+m[2][3]*a.m[3][1];
	s.m[2][2]=m[2][0]*a.m[0][2]+m[2][1]*a.m[1][2]+m[2][2]*a.m[2][2];//+m[2][3]*a.m[3][2];
	s.m[2][3]=m[2][0]*a.m[0][3]+m[2][1]*a.m[1][3]+m[2][2]*a.m[2][3];//+m[2][3]*a.m[3][3];

	s.m[3][0]=m[3][0]*a.m[0][0]+m[3][1]*a.m[1][0]+m[3][2]*a.m[2][0]+m[3][3]*a.m[3][0];
	s.m[3][1]=m[3][0]*a.m[0][1]+m[3][1]*a.m[1][1]+m[3][2]*a.m[2][1]+m[3][3]*a.m[3][1];
	s.m[3][2]=m[3][0]*a.m[0][2]+m[3][1]*a.m[1][2]+m[3][2]*a.m[2][2]+m[3][3]*a.m[3][2];
	s.m[3][3]=m[3][0]*a.m[0][3]+m[3][1]*a.m[1][3]+m[3][2]*a.m[2][3]+m[3][3]*a.m[3][3];


	return(s);
}

Matrix Matrix::operator*(const float f) 
{
	Matrix s;
	for (int i=0;i<4;i++)
		for (int j=0;j<4;j++)
			s.m[i][j]=m[i][j]*f;
		return(s);
}

void Matrix::Translate(const Vector &a)
{
	m[0][1]  =  m[0][2]  =  m[0][3]=0;
	m[1][0]  =  m[1][2]  =  m[1][3]=0;
	m[2][0]  =  m[2][1]  =  m[2][3]=0;
	m[3][0]=a.x;m[3][1]=a.y;m[3][2]=a.z;
	m[0][0]=m[1][1]=m[2][2]=1;m[3][3]=1;
	
}

void Matrix::Transpose()
{
	Matrix t;

	memcpy(&t.m,m,sizeof(Matrix));
	for(int i=0;i<4;i++)
		for(int j=0;j<4;j++)
			m[i][j]=t.m[j][i];
}

void Matrix::Scale(const Vector &a)
{
	m[0][1]=m[0][2]=m[0][3]=0;
	m[1][0]=m[1][2]=m[1][3]=0;
	m[2][0]=m[2][1]=m[2][3]=0;
	m[3][0]=m[3][1]=m[3][2]=0;
    m[0][0]=a.x;
	m[1][1]=a.y;
	m[2][2]=a.z;
	m[3][3]=1;
}

void Matrix::ScaleRows(const Vector &v)
{
	m[0][0]*=v.x;m[0][1]*=v.x;m[0][2]*=v.x;
	m[1][0]*=v.y;m[1][1]*=v.y;m[1][2]*=v.y;
	m[2][0]*=v.z;m[2][1]*=v.z;m[2][2]*=v.z;
}
void Matrix::Location(const Vector &a)
{
	m[3][0]=a.x;m[3][1]=a.y;m[3][2]=a.z;m[3][3]=1;
}

void Matrix::Set(const int i,const int j,const float f)
{
	m[i][j]=f;
}

Wector Matrix::operator*(const Wector &a)
{
	Wector s;
	s.x=m[0][0]*a.x+m[1][0]*a.y+m[2][0]*a.z+m[3][0];
	s.y=m[0][1]*a.x+m[1][1]*a.y+m[2][1]*a.z+m[3][1];
	s.z=m[0][2]*a.x+m[1][2]*a.y+m[2][2]*a.z+m[3][2];
	s.w=m[0][3]*a.x+m[1][3]*a.y+m[2][3]*a.z+m[3][3];
	return s;
}

Vector Matrix::operator*(const Vector &a)
{
	Vector s;
	s.x=m[0][0]*a.x+m[1][0]*a.y+m[2][0]*a.z+m[3][0];
	s.y=m[0][1]*a.x+m[1][1]*a.y+m[2][1]*a.z+m[3][1];
	s.z=m[0][2]*a.x+m[1][2]*a.y+m[2][2]*a.z+m[3][2];
	return s;
}

Vector Matrix::operator%(const Vector &a)
{
	Vector s;
	s.x=m[0][0]*a.x+m[1][0]*a.y+m[2][0]*a.z;
	s.y=m[0][1]*a.x+m[1][1]*a.y+m[2][1]*a.z;
	s.z=m[0][2]*a.x+m[1][2]*a.y+m[2][2]*a.z;
	return s;
}

Matrix Matrix::Invert2()
{
//  mat_inverse: inverse matrix calculation (non-singular).

	int		i, j;
	float	scale;
	Matrix	temp,t,out;
	Vector	v;

    temp.Identity();
     
	v.x=-m[3][0];
    v.y=-m[3][1];
    v.z=-m[3][2];
	t.Translate(v);

	for (i=0;i<3;i++) 
	{
		scale = m[i][0]*m[i][0] + m[i][1]*m[i][1] + m[i][2]*m[i][2];
		scale = 1.0f / scale;
		for (j=0;j<3;j++) temp.m[i][j] = m[j][i] * scale;
	}
	
	out=t*temp;
	return out;
}

Matrix Matrix::Invert() {

	Matrix out,M;

	M=*this;

	float a = 1 / (M.m[0][0]*(M.m[1][1]*M.m[2][2]-M.m[1][2]*M.m[2][1]) +
		M.m[0][1]*(M.m[1][2]*M.m[2][0]-M.m[1][0]*M.m[2][2]) +
		M.m[0][2]*(M.m[1][0]*M.m[2][1]-M.m[1][1]*M.m[2][0]));


	m[0][0] = (M.m[1][1]*M.m[2][2] - M.m[1][2]*M.m[2][1]) * a;
	m[0][1] = (M.m[0][2]*M.m[2][1] - M.m[0][1]*M.m[2][2]) * a;
	m[0][2] = (M.m[0][1]*M.m[1][2] - M.m[0][2]*M.m[1][1]) * a;
	m[0][3] = 0;
	m[1][0] = (M.m[1][2]*M.m[2][0] - M.m[1][0]*M.m[2][2]) * a;
	m[1][1] = (M.m[0][0]*M.m[2][2] - M.m[0][2]*M.m[2][0]) * a;
	m[1][2] = (M.m[0][2]*M.m[1][0] - M.m[0][0]*M.m[1][2]) * a;
	m[1][3] = 0;
	m[2][0] = (M.m[1][0]*M.m[2][1] - M.m[1][1]*M.m[2][0]) * a;
	m[2][1] = (M.m[0][1]*M.m[2][0] - M.m[0][0]*M.m[2][1]) * a;
	m[2][2] = (M.m[0][0]*M.m[1][1] - M.m[0][1]*M.m[1][0]) * a;
	m[2][3] = 0;

	out=*this;

	out.m[3][0] = -m[3][0]*M.m[0][0]-m[3][1]*M.m[0][1]-m[3][2]*M.m[0][2];
	out.m[3][1] = -m[3][0]*M.m[1][0]-m[3][1]*M.m[1][1]-m[3][2]*M.m[1][2];
	out.m[3][2] = -m[3][0]*M.m[2][0]-m[3][1]*M.m[2][1]-m[3][2]*M.m[2][2];
	out.m[3][3] = 1;

	return out;
}
