#pragma warning( disable : 4244 4305 )
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

#include "..\h\quat.h"
#include "..\h\console.h"
#include "..\h\matrix.h"

#define PI 3.1415926535897932384626433832795

void Quaternion::printf() const {
	::conprintf("w:%f x:%f y:%f z:%f\n", w, x, y, z);
}

Quaternion Quaternion::operator-() 
{
	return Quaternion(w, -x, -y, -z);
}

float Quaternion::Length() 
{
	return ((float)sqrt(x*x+y*y+z*z+w*w));
}

float Quaternion::Norm() 
{
	return (x*x+y*y+z*z+w*w);
}

void Quaternion::Normalize() 
{
	float l=(float)1./(float)sqrt(x*x+y*y+z*z+w*w);
	x*=l;
	y*=l;
	z*=l;
	w*=l;
}


Quaternion Quaternion::operator+(const Quaternion &b)
{
	return Quaternion(x+b.x, y+b.y, z+b.z, w+b.w);
}

Quaternion Quaternion::operator-(const Quaternion &b)
{
	return Quaternion(x-b.x, y-b.y, z-b.z, w-b.w);
}

Quaternion Quaternion::operator%(const Quaternion &b)
{
	return Quaternion(
		w*b.x + x*b.w + y*b.z - z*b.y,
		w*b.y + y*b.w + z*b.x - x*b.z,
		w*b.z + z*b.w + x*b.y - y*b.x,
		w*b.w - x*b.x - y*b.y - z*b.z
		);
}

Quaternion Quaternion::operator*(const float f)
{
	return Quaternion(x*f,y*f,z*f,w*f);
}

float Quaternion::operator*(const Quaternion &b)
{
	return (x*b.x + y*b.y + z*b.z + w*b.w);
}

void Quaternion::Convert(float s,Vector &v)
{
	float	ss;
	
	ss=sin(s*.5);

	w=float(cos(s*.5));
	x=float(v.x*ss);
    y=float(v.y*ss);
    z=float(v.z*ss);
}

Matrix Quaternion::ConvertToMatrix()
{
	Matrix a;

	a.m[0][0]=1 - 2 * (y * y + z * z);
    a.m[0][1]=2 * (x * y + w * z);
    a.m[0][2]=2 * (x * z - w * y);
    a.m[0][3]=0;

    a.m[1][0]=2 * (x * y - w * z);
    a.m[1][1]=1 - 2 * (x * x + z * z);
    a.m[1][2]=2 * (y * z + w * x);
    a.m[1][3]=0;

    a.m[2][0]=2 * (x * z + w * y);
    a.m[2][1]=2 * (y * z - w * x);
    a.m[2][2]=1 - 2 * (x * x + y * y);
    a.m[2][3]=0;

    a.m[3][0]=0;
    a.m[3][1]=0;
    a.m[3][2]=0;
    a.m[3][3]=1;

	return(a);
}

