#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

#include "..\h\vector.h"
#include "..\h\console.h"

void Vector::printf() 
{
	::conprintf("x:%f y:%f z:%f\n",x,y,z);
}

float Vector::Length() 
{
	return((float)sqrt(x*x+y*y+z*z));
}

float Vector::Length2() 
{
	return((float)(x*x+y*y+z*z));
}

Vector Vector::operator-() 
{
	return (Vector(-x,-y,-z));
}

Vector Vector::operator+(const Vector &a) 
{
	return (Vector(a.x+x,a.y+y,a.z+z));
}

Vector Vector::operator-(const Vector &a) 
{
	return (Vector(x-a.x,y-a.y,z-a.z));
}

float Vector::operator*(const Vector &a) 
{
	return (a.x*x+a.y*y+a.z*z);
}

Vector Vector::operator%(const Vector &a) 
{
	return (Vector(y*a.z-z*a.y,z*a.x-x*a.z,x*a.y-y*a.x));
}

Vector Vector::operator+=(const Vector &a) 
{
	x+=a.x;
	y+=a.y;
	z+=a.z;
	return *this;
}

Vector Vector::operator-=(const Vector &a) 
{
	x-=a.x;
	y-=a.y;
	z-=a.z;
	return *this;
}

Vector Vector::operator*=(const float &a) 
{
	x*=a;
	y*=a;
	z*=a;
	return *this;
}

Vector Vector::operator/=(const float &a)
{
	float b=(float)1./a;
	x*=b;
	y*=b;
	z*=b;
	return *this;
}

Vector Vector::operator*(const float &a)
{
	return Vector(a*x,a*y,a*z);
}

Vector Vector::operator/(const float &a)
{
	float b=(float)1./a;
	return Vector(b*x,b*y,b*z);
}

void Vector::Normalize()
{
	float l=(float)1./(float)sqrt(x*x+y*y+z*z);
	x*=l;
	y*=l;
	z*=l;
}
