#ifndef _MathLoaded_
#define _MathLoaded_
#include <math.h>
#endif

#include "..\h\vector.h"
#include "..\h\wector.h"
#include "..\h\console.h"


void Wector::printf() {
	::conprintf("x:%f y:%f z:%f w:%f\n",x,y,z,w);
}

float Wector::Length() {
	return((float)sqrt(x*x+y*y+z*z+w*w));
}

Wector Wector::operator-() 
{
	return Wector(-x,-y,-z,-w);
}

Wector Wector::operator+(const Wector &a) 
{
	return Wector(a.x+x,a.y+y,a.z+z,a.w+w);
}

Wector Wector::operator-(const Wector &a) 
{
	return Wector(x-a.x,y-a.y,z-a.z,w-a.w);
}

float Wector::operator*(const Wector &a) 
{
	return (a.x*x+a.y*y+a.z*z+a.w*w);
}

Wector Wector::operator+=(const Wector &a) 
{
	x+=a.x;
	y+=a.y;
	z+=a.z;
	w+=a.w;
	return *this;
}

Wector Wector::operator-=(const Wector &a) 
{
	x-=a.x;
	y-=a.y;
	z-=a.z;
	w-=a.w;
	return *this;
}

Wector Wector::operator*=(const float &a) 
{
	x*=a;
	y*=a;
	z*=a;
	w*=a;
	return *this;
}

Wector Wector::operator/=(const float &a) 
{
	float b=(float)1./a;
	x*=b;
	y*=b;
	z*=b;
	w*=b;
	return *this;
}

Wector Wector::operator*(const float &a)
{
	return Wector(a*x,a*y,a*z,a*w);
}

Wector Wector::operator/(const float &a)
{
	float b=(float)1./a;
	return Wector(b*x,b*y,b*z,b*w);
}

Wector Wector::operator=(const Vector &a)
{
	x=a.x;
	y=a.y;
	z=a.z;
	w=1;
	return *this;
}
