#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>
#include <stdio.h>
#include <commctrl.h>
#include "h\AE3DS.h"
#include "h\AEUtils.h"
#include "h\console.h"
#include "resource.h"

HINSTANCE		hInstance;
HWND			hWnd;

bool			FULLSCREEN=false;
BOOL			g_bActive = FALSE;
HDC				hDC;
HPALETTE		hPalette = 0;
HFONT			font;
float			GlobalTimer=0;
float			FrameStep=(float)1;
BOOL			Loaded = FALSE;
int				FrameCounter=10;
int				FrameTime=0;
float			FramePerSec=0.0;

AE3DS			*test;

RECT			Client;
DEVMODE			DevMode;

//OPENGL EXTENSION!!!!!!!
PFNGLACTIVETEXTUREARBPROC          glActiveTextureARB          = NULL;
PFNGLMULTITEXCOORD2FARBPROC        glMultiTexCoord2fARB        = NULL;
PFNGLCLIENTACTIVETEXTUREARBPROC	   glClientActiveTextureARB		= NULL;

struct {
    int id;
    char *String;
}  AE3DSError[] = {
	{0x201,	"AE3DS File Not Found!"},
	{0x202,	"AE3DS No Cameras defined!"},
	{0x203,	"AE3DS No Object defined!"},
	{0x801,	"ijlInit Failure"},
	{0x802, "ijlRead File Not Found"},
	{0x803, "JPG Is Incorrect Size"},
	{0x804, "ijlRead Invalide File Format"},
	{0x805, "ijlFree Failure"},
	{-1,	"AE3DS Internal Error"},
};


/********************/
void UpdateFrame(void)
/********************/
{
	int StartTime, EndTime, len;
	char Fps[128];
	AECAMERA tempcam;

	//**********
	if (Loaded)
	{
		StartTime=GetTickCount();

		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		test->SetFrame((float)fmod(GlobalTimer,test->EndFrame));
		test->RenderFrame();
		
		GlobalTimer+=(float)FrameStep;
		if (GlobalTimer<0) GlobalTimer=(float)test->EndFrame;

		SwapBuffers(hDC);
		EndTime=GetTickCount();
		FrameTime+=(EndTime-StartTime);
		FrameCounter--;
		if (!FrameCounter) {
			FrameCounter=10;
			FramePerSec=1000*10/(float)FrameTime;
			FrameTime=0;
		}
		SelectObject(hDC, font);
		len=sprintf(Fps,"Ticks: %i (FPS: %3.0f)",EndTime-StartTime,FramePerSec);
		TextOut(hDC, 0, 0, Fps, len);
	}
}

// Hacky setup screen procedure
BOOL CALLBACK DialogProc( HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
static AE3DS *actual;

    switch(uMsg) 
	{

	case WM_INITDIALOG:
		actual=(AE3DS*)lParam;
		if (!actual) {
			EndDialog(hwndDlg,-1);
			return(0);
		}
		CheckDlgButton( hwndDlg, IDC_AUTOFAR, BST_CHECKED);
		CheckDlgButton( hwndDlg, IDC_SHADING, BST_CHECKED);
		CheckDlgButton( hwndDlg, IDC_DISABLETRANSP, BST_CHECKED);
 		SetDlgItemInt( hwndDlg, IDC_FARPLANE, 10000, FALSE);
		if (actual->NumLights<1 && actual->NumAmbientNodes<2) {
			CheckDlgButton( hwndDlg, IDC_SHADING, BST_UNCHECKED);
			EnableWindow( GetDlgItem(hwndDlg, IDC_SHADING), FALSE);
			actual->Ambient->Col.Set(1,1,1);
		}
		actual->DefaultFarClippingPlane=10000;
		break;

	case WM_CLOSE:
		PostQuitMessage(0);
		return 0;
	
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
			int flag=0;
			if (IsDlgButtonChecked( hwndDlg, IDC_AUTOFAR)==BST_CHECKED) {
				flag|=AE_AUTOFAR;
			} else {
				actual->DefaultFarClippingPlane=(float)GetDlgItemInt(hwndDlg, IDC_FARPLANE, NULL, FALSE);
			}
			if (IsDlgButtonChecked( hwndDlg, IDC_DRAWGLOWS)==BST_CHECKED) flag|=AE_DRAWGLOWS;
			if (IsDlgButtonChecked( hwndDlg, IDC_FOG)==BST_CHECKED) flag|=AE_FOG;
			if (IsDlgButtonChecked( hwndDlg, IDC_LIGHTMAPS)==BST_CHECKED) {
				flag|=AE_LIGHTMAPS;
				flag|=AE_DONTSHADE;
			} else {
				if (IsDlgButtonChecked( hwndDlg, IDC_SHADING)==BST_UNCHECKED) {
					flag|=AE_DONTSHADE;
				} else {
					if (IsDlgButtonChecked( hwndDlg, IDC_DISABLETRANSP)==BST_CHECKED) flag|=AE_DONTSHADETRANSPARENT;
					if (IsDlgButtonChecked( hwndDlg, IDC_LIGHTDISTANCE)==BST_CHECKED) flag|=AE_LIGHTDISTANCECOUNTS;
				}
			}
			EndDialog(hwndDlg,flag);
			return 0;
		}
	}

	if (IsDlgButtonChecked( hwndDlg, IDC_AUTOFAR)==BST_CHECKED) {
		EnableWindow( GetDlgItem(hwndDlg, IDC_USECAMERA), FALSE);
		EnableWindow( GetDlgItem(hwndDlg, IDC_FARPLANE), FALSE);
		EnableWindow( GetDlgItem(hwndDlg, IDC_TEXT1), FALSE);
	} else {
		EnableWindow( GetDlgItem(hwndDlg, IDC_USECAMERA), TRUE);
		if (IsDlgButtonChecked( hwndDlg, IDC_USECAMERA)==BST_CHECKED) {
			EnableWindow( GetDlgItem(hwndDlg, IDC_FARPLANE), FALSE);
			EnableWindow( GetDlgItem(hwndDlg, IDC_TEXT1), FALSE);
		} else {
			EnableWindow( GetDlgItem(hwndDlg, IDC_FARPLANE), TRUE);
			EnableWindow( GetDlgItem(hwndDlg, IDC_TEXT1), TRUE);
		}
	}

	if (IsDlgButtonChecked( hwndDlg, IDC_SHADING)==BST_CHECKED) {
		EnableWindow( GetDlgItem(hwndDlg, IDC_DISABLETRANSP), TRUE);
		EnableWindow( GetDlgItem(hwndDlg, IDC_LIGHTDISTANCE), TRUE);
	} else {
		EnableWindow( GetDlgItem(hwndDlg, IDC_DISABLETRANSP), FALSE);
		EnableWindow( GetDlgItem(hwndDlg, IDC_LIGHTDISTANCE), FALSE);
	}

    return DefWindowProc(hWnd, uMsg, wParam, lParam); 
}
  


LONG WINAPI WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{ 
    static PAINTSTRUCT ps;
	static Vector dir;

    switch(uMsg) 
	{
	case WM_SIZE:
		GetClientRect(hWnd,&Client);
		glViewport(0, 0, LOWORD(lParam), HIWORD(lParam));
		PostMessage(hWnd, WM_PAINT, 0, 0);
		return 0;
	case WM_CHAR:
		// keys 1..9 change cameras
		if (wParam>48 && wParam<57) test->SetCamera(wParam-49);
		switch (wParam) 
		{
		case 27: // ESC
			ChangeDisplaySettings(NULL,0);
			PostQuitMessage(0);
			break;
		case '+': // speed up
			FrameStep+=0.01f;
			break;
		case '-': // slow down (you can change to backwards playing!)
			FrameStep-=0.01f;
			break;
		}
		return 0;
	case WM_ACTIVATE:
		if (!IsIconic(hWnd)) g_bActive=TRUE;
		return 0;

	case WM_PALETTECHANGED:
		if (hWnd == (HWND)wParam) break;
    case WM_QUERYNEWPALETTE:
		if (hPalette)
		{
			UnrealizeObject(hPalette);
			SelectPalette(hDC, hPalette, FALSE);
			RealizePalette(hDC);
			return TRUE;
		}
		return FALSE;
		
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case ID_FILE_EXIT:
			PostQuitMessage(0);
			return 0;
		case ID_ABOUT:
			MessageBox(hWnd,"3DS Player Test Application","About 3DS Player",MB_OK);
			return 0;
		case ID_LOAD:
			OPENFILENAME ofn;
			char fname[256];
			int res;

			glClear(GL_COLOR_BUFFER_BIT);
			SwapBuffers(hDC);
			
			fname[0]='\0';
			memset(&ofn,0,sizeof(OPENFILENAME));

			ofn.lStructSize=sizeof(OPENFILENAME);
			ofn.hwndOwner=hWnd;
			ofn.hInstance=hInstance;
			ofn.lpstrFilter="3D Studio Animation Files (*.3DS)\0*.3DS\0";
			ofn.nFilterIndex=1;
			ofn.lpstrFile=fname;
			ofn.nMaxFile=256;
			ofn.Flags=OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_EXPLORER;

			res=GetOpenFileName(&ofn);
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			hDC=GetDC(hWnd);
			SwapBuffers(hDC);

			if (res) 
			{
				test = new AE3DS;
				GlobalTimer = 0;
				Loaded=TRUE;

				res=test->Load3ds(fname);
				if (res!=0)
				{
					Loaded=FALSE;
					for (int i=0;i<sizeof(AE3DSError)/sizeof(AE3DSError[0]);i++)
						if (AE3DSError[i].id==res) break;
					MessageBox(hWnd,AE3DSError[i].String,"Error",0);

					return FALSE;
				} 

				test->DefaultFarClippingPlane=1000;
				test->DefaultNearClippingPlane=1;
				int flag=DialogBoxParam( hInstance, MAKEINTRESOURCE(IDD_ANIMPROP), hWnd, (int (__stdcall *)(void))&DialogProc, (LPARAM)test);
				if (flag!=-1) {
					res=test->InitAE(flag);
					test->SetCamera(0);
					test->SetFrame(0);
				} else {Loaded=FALSE;}

				if (res!=0)
				{
					for (int i=0;i<sizeof(AE3DSError)/sizeof(AE3DSError[0]);i++)
						if (AE3DSError[i].id==res) break;
					MessageBox(hWnd,AE3DSError[i].String,"Error",0);
				}
			}
			else conprintf("%x\n",CommDlgExtendedError());
			break;
		}
		break;

	case WM_CLOSE:
		PostQuitMessage(0);
		return 0;
	}

    return DefWindowProc(hWnd, uMsg, wParam, lParam); 
} 

HWND CreateOpenGLWindow(char* title, int width, int height, BYTE type, DWORD flags)
{
    int         n, pf;
	WNDCLASS    wc;
	LOGPALETTE* lpPal;
	PIXELFORMATDESCRIPTOR pfd;

	if (!hInstance) 
	{
		hInstance = GetModuleHandle(NULL);
		wc.style         = CS_OWNDC;
		wc.lpfnWndProc   = (WNDPROC)WindowProc;
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 0;
		wc.hInstance     = hInstance;
		wc.hIcon         = LoadIcon(NULL, IDI_WINLOGO);
		wc.hbrBackground = NULL;
		wc.lpszClassName = "3DS Player";

if (FULLSCREEN ) {
		wc.lpszMenuName  = NULL;
		wc.hCursor       = NULL;
} else {
		wc.lpszMenuName  = NULL;//"EngineMenu";
		wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
}

		if (!RegisterClass(&wc)) 
		{
			MessageBox(NULL, "RegisterClass() failed:  Cannot register window class.", "Error", MB_OK);
			return NULL;
		}
	}

if (FULLSCREEN) {
	Client.left=0;
	Client.right=width;
	Client.top=0;
	Client.bottom=height;
	hWnd = CreateWindowEx(
		WS_EX_APPWINDOW | WS_EX_TOPMOST, 
		"3DS Player", title, 
		WS_POPUP,
		Client.left, Client.top, Client.right-Client.left, Client.bottom-Client.top,
		NULL, NULL, hInstance, NULL);
} else {
	Client.left=0;//(GetSystemMetrics(SM_CXFULLSCREEN)-width)/2;
	Client.right=width;//(GetSystemMetrics(SM_CXFULLSCREEN)-width)/2+width;
	Client.top=0;//(GetSystemMetrics(SM_CYFULLSCREEN)-height)/2;
	Client.bottom=height;//(GetSystemMetrics(SM_CYFULLSCREEN)-height)+height;
	AdjustWindowRect(&Client,WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN , TRUE);
	hWnd = CreateWindowEx(
		WS_EX_APPWINDOW | WS_EX_WINDOWEDGE ,
		"3DS Player", title,
		WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
		0,0, Client.right-Client.left, Client.bottom-Client.top,
//		Client.left, Client.top, Client.right-Client.left, Client.bottom-Client.top,
		NULL, NULL, hInstance, NULL);
}

	if (hWnd == NULL) 
	{
		MessageBox(NULL, "CreateWindow() failed:  Cannot create a window.",  "Error", MB_OK);
		return NULL;
	}

	hDC = GetDC(hWnd);
    memset(&pfd, 0, sizeof(pfd));
	pfd.nSize        = sizeof(pfd);
	pfd.nVersion     = 1;
	pfd.dwFlags      = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | flags;
	pfd.iPixelType   = type;
	pfd.cColorBits   = 32;
	pfd.cDepthBits   = 24;
	//pfd.cStencilBits = 8;

	pf = ChoosePixelFormat(hDC, &pfd);
	if (pf == 0) 
	{
		MessageBox(NULL, "ChoosePixelFormat() failed:  Cannot find a suitable pixel format.", "Error", MB_OK); 
		return 0;
	} 
 
	if (SetPixelFormat(hDC, pf, &pfd) == FALSE) 
	{
		MessageBox(NULL, "SetPixelFormat() failed:  Cannot set format specified.", "Error", MB_OK);
		return 0;
	} 

	DescribePixelFormat(hDC, pf, sizeof(PIXELFORMATDESCRIPTOR), &pfd);

	if (pfd.dwFlags & PFD_NEED_PALETTE || pfd.iPixelType == PFD_TYPE_COLORINDEX) 
	{
		n = 1 << pfd.cColorBits;
		if (n > 256) n = 256;
		lpPal = (LOGPALETTE*)malloc(sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * n);
		memset(lpPal, 0, sizeof(LOGPALETTE) + sizeof(PALETTEENTRY) * n);
		lpPal->palVersion = 0x300;
		lpPal->palNumEntries = n;
		GetSystemPaletteEntries(hDC, 0, n, &lpPal->palPalEntry[0]);
		if (pfd.iPixelType == PFD_TYPE_RGBA) 
		{
			int redMask = (1 << pfd.cRedBits) - 1;
			int greenMask = (1 << pfd.cGreenBits) - 1;
			int blueMask = (1 << pfd.cBlueBits) - 1;
			int i;

		    for (i = 0; i < n; ++i) 
			{
				lpPal->palPalEntry[i].peRed = (((i >> pfd.cRedShift)   & redMask)   * 255) / redMask;
				lpPal->palPalEntry[i].peGreen = (((i >> pfd.cGreenShift) & greenMask) * 255) / greenMask;
				lpPal->palPalEntry[i].peBlue = (((i >> pfd.cBlueShift)  & blueMask)  * 255) / blueMask;		lpPal->palPalEntry[i].peFlags = 0;
			}
		} 
		else 
		{
			lpPal->palPalEntry[0].peRed = 0;
			lpPal->palPalEntry[0].peGreen = 0;
			lpPal->palPalEntry[0].peBlue = 0;
			lpPal->palPalEntry[0].peFlags = PC_NOCOLLAPSE;
			lpPal->palPalEntry[1].peRed = 255;
			lpPal->palPalEntry[1].peGreen = 0;
			lpPal->palPalEntry[1].peBlue = 0;
			lpPal->palPalEntry[1].peFlags = PC_NOCOLLAPSE;
			lpPal->palPalEntry[2].peRed = 0;
			lpPal->palPalEntry[2].peGreen = 255;
			lpPal->palPalEntry[2].peBlue = 0;
			lpPal->palPalEntry[2].peFlags = PC_NOCOLLAPSE;
			lpPal->palPalEntry[3].peRed = 0;
			lpPal->palPalEntry[3].peGreen = 0;
			lpPal->palPalEntry[3].peBlue = 255;
			lpPal->palPalEntry[3].peFlags = PC_NOCOLLAPSE;
		}

		hPalette = CreatePalette(lpPal);
		if (hPalette) 
		{
			SelectPalette(hDC, hPalette, FALSE);
			RealizePalette(hDC);
		}

		free(lpPal);
	}
	
	ReleaseDC(hWnd,hDC);

	return hWnd;
}    


int APIENTRY WinMain(HINSTANCE hCurrentInst, HINSTANCE hPreviousInst,
	LPSTR lpszCmdLine, int nCmdShow)
{
	HGLRC hRC;
	HWND  hWnd;
	MSG   msg;
	DWORD buffer = PFD_DOUBLEBUFFER;
	BYTE  color  = PFD_TYPE_RGBA;

    font = CreateFont(24, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, NONANTIALIASED_QUALITY, VARIABLE_PITCH,"Arial");    

	if (FULLSCREEN) {
		memset(&DevMode,0,sizeof(DevMode));
		DevMode.dmSize=sizeof(DevMode);
		DevMode.dmBitsPerPel=32;
		DevMode.dmPelsWidth=640;
		DevMode.dmPelsHeight=480;
		DevMode.dmDisplayFrequency=70;
		//DevMode.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT|DM_DISPLAYFREQUENCY;
		DevMode.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;
		ChangeDisplaySettings(&DevMode,0);
	}

	hWnd = CreateOpenGLWindow("3DS Player", 640, 480, color, buffer);
	if (hWnd == NULL) exit(1);
	hDC = GetDC(hWnd);
	hRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hRC);

	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);


#ifdef GDIOPEN
	//	if ( !hPrevInstance )   {
	memset(&wc2,0,sizeof(wc2));

	wc2.lpszClassName = "WClass1";
	wc2.lpfnWndProc = MainWndProc;
	wc2.style = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
	wc2.hInstance = hInstance;
	wc2.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
	wc2.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc2.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wc2.lpszMenuName = 0;
	wc2.cbClsExtra = 0;
	wc2.cbWndExtra = 0;
	RegisterClass( &wc2 );

	WindowRect.left = (GetSystemMetrics(SM_CXSCREEN)-GDIX) / 2;
	WindowRect.top = (GetSystemMetrics(SM_CYSCREEN)-GDIY) / 2;
	WindowRect.right = WindowRect.left + GDIX;
	WindowRect.bottom = WindowRect.top + GDIY;
	AdjustWindowRect( &WindowRect, WS_CAPTION, FALSE );


	hWnd2 = CreateWindow( "WClass1", "Software Filler",WS_POPUP | WS_MINIMIZEBOX | WS_SYSMENU | WS_CAPTION,
		WindowRect.left, WindowRect.top, 
		WindowRect.right - WindowRect.left,
		WindowRect.bottom - WindowRect.top,
		NULL, NULL, hInstance, NULL );
//		}

	ShowWindow( hWnd2, SW_SHOW );

	hdc2 = GetDC( hWnd2 );  
    GetClientRect( hWnd2, &WindowRect);

	memset(&bmHeader,0,sizeof(bmHeader));
	bmHeader.biSize = sizeof( BITMAPINFOHEADER );
	bmHeader.biWidth = GDIX;
	bmHeader.biHeight = -GDIY;
    bmHeader.biPlanes= 1;
    bmHeader.biBitCount = 32;
	bmHeader.biCompression = BI_RGB;
	bmHeader.biSizeImage = GDIX*GDIY*4;

	bmInfo.bmiHeader = bmHeader;
	bmInfo.bmiColors[1] = rgbQuad[1];
#endif


	glEnable(GL_DEPTH_TEST);
	glClear(GL_COLOR_BUFFER_BIT);
	glClear(GL_DEPTH_BUFFER_BIT);
	glActiveTextureARB = (PFNGLACTIVETEXTUREARBPROC)wglGetProcAddress("glActiveTextureARB");
	glMultiTexCoord2fARB = (PFNGLMULTITEXCOORD2FARBPROC)wglGetProcAddress("glMultiTexCoord2fARB");
	glClientActiveTextureARB = (PFNGLCLIENTACTIVETEXTUREARBPROC)wglGetProcAddress("glClientActiveTextureARB");

	// either this....
	SendMessage(hWnd,WM_COMMAND,ID_LOAD,0);

	//...or these
	//test=new AE3DS;
	//test->Load3ds("scene_a.3ds");
	//test->InitAE(AE_AUTOFAR | AE_DONTSHADETRANSPARENT);
	//Loaded=TRUE;

	SetFocus(hWnd);
	SwapBuffers(hDC);

	while (TRUE)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
		{
			if (!GetMessage(&msg, NULL, 0, 0)) return msg.wParam;
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		} 
		else if (g_bActive)
		{
			UpdateFrame();
		} 
		else
		{
			WaitMessage();
		}
	}
	ChangeDisplaySettings(NULL,0);

    wglMakeCurrent(NULL, NULL);
	ReleaseDC(hDC, hWnd);
	wglDeleteContext(hRC);
	DestroyWindow(hWnd);
	DeleteDC(hDC);
	if (hPalette) DeleteObject(hPalette);
	return 0;
}