REM ESTE ES EL NUCLEO DE IMPRESION DE LOS PROGRAMAS. PERMITE USARLOS CON
REM CUALQUIER TARJETA GRAFICA.

REM INDICA CUAL ES LA TARJETA GRAFICA QUE PREFIERES EN LA VARIABLE TARJETA:
REM 1=CGA 4 COLORES (320 x 200 puntos)
REM 2=CGA 2 COLORES (640 x 200 puntos)
REM 3=EGA 16 COLORES (640 x 350 puntos)
REM 4=MCGA 2 COLORES (640 x 480 puntos)
REM 5=MCGA 256 COLORES (320 x 200 puntos)
REM 6=VGA/SVGA 16 COLORES (640 x 480 puntos)
REM 7=AT&T 2 COLORES (640 x 400 puntos)
REM 8=HERCULES 2 COLORES (720 x 348 puntos)
REM Para usar la tarjeta HERCULES, ejecutar antes desde DOS
REM la controladora de dispositivos MSHERC.COM

TARJETA = 1
GOSUB PREPARAR

REM LA VARIABLE RELAS INDICA LA RELACION DE ASPECTO DEL DISPOSITIVO DE SALIDA

RELAS = 3 / 4

REM CALCULAMOS LOS VALORES DE RELACION

IF RELAS <= 1 THEN
     REX = 480 / RELAS
     REY = 480
ELSE
     REX = 480
     REY = 480 * RELAS
END IF

REM LAS VARIABLES XMAX E YMAX SON LAS PROPORCIONES ENTRE LAS COORDENADAS
REM VISUALES Y LAS ESPECIFICAS.

RELX = XMAX / REX
RELY = YMAX / REY

REM LA SUBRUTINA PINTAR (VER EXPLICACION EN EL LISTADO) PRECISA DE LOS
REM PARAMETROS DE LA SUBRUTINA PREPARAR. ADEMAS, SE DEBEN DAR LAS
REM SIGUIENTES VARIABLES:
REM XI,YI COORDENADAS INICIALES
REM XF,YF COORDENADAS FINALES
REM COLORES COLOR DESEADO PARA LA LINEA (VALORES DESDE CERO HASTA QUINCE)

REM D ES LA DISTANCIA DESDE EL OBSERVADOR A LA PANTALLA EN PIXELS

D = 1000
END
  
PINTAR:
   
     REM ESTA SUBRUTINA AJUSTA LAS COORDENADAS A LAS DIMENSIONES REALES
     REM DE LA PANTALLA Y PINTA LAS RECTAS CON EL COLOR CORRESPONDIENTE,
     REM AJUSTANDOLO SI TRABAJAMOS CON MENOS DE 16 COLORES.
   
     IF NUMCOLOR = 2 THEN COLORES = 1
     IF NUMCOLOR = 4 THEN COLORES = COLORES * 3 / 16 + 1
     LINE (XI * RELX, YI * RELY)-(XF * RELX, YF * RELY), COLORES
     RETURN


PREPARAR:
     REM ESTA SUBRUTINA ACTUALIZA LA PANTALLA EN EL MODO ESCOGIDO
     REM Y DA LOS VALORES ADECUADOS A LOS PARAMETROS DE PANTALLA
    
     ON TARJETA GOSUB CGA1, CGA2, EGA, MCGA1, MCGA2, VGA, ATT, HERCULES
     CLS
     RETURN

CGA1:
     XMAX = 320
     YMAX = 200
     SCREEN 1
     NUMCOLOR = 4
     RETURN

CGA2:
     XMAX = 640
     YMAX = 200
     SCREEN 2
     NUMCOLOR = 2
     RETURN

EGA:
     XMAX = 640
     YMAX = 350
     SCREEN 9
     NUMCOLOR = 16
     RETURN

MCGA1:
     XMAX = 640
     YMAX = 480
     SCREEN 11
     NUMCOLOR = 2
     RETURN

MCGA2:
     XMAX = 320
     YMAX = 200
     SCREEN 13
     NUMCOLOR = 256
     RETURN

VGA:
     XMAX = 640
     YMAX = 480
     SCREEN 12
     NUMCOLOR = 16
     RETURN

ATT:
     XMAX = 640
     YMAX = 400
     SCREEN 4
     NUMCOLOR = 2
     RETURN

HERCULES:
     XMAX = 720
     YMAX = 348
     SCREEN 3
     NUMCOLOR = 2
     RETURN

