REM PROGRAMA DE DEMOSTRACION 7
REM ROTACION DE UN CUBO EN TRES DIMENSIONES
REM CON ELIMINACION DE SUPERFICIES OCULTAS
REM POR EL METODO DEL PINTOR

REM CONTROLES:
REM Q, A: ROTAR EN EL EJE X
REM P, O: ROTAR EN EL EJE Y
REM K, L: ROTAR EN EL EJE Z
REM R: COLOREAR
REM S: TERMINAR

REM INDICA CUAL ES LA TARJETA GRAFICA QUE PREFIERES EN LA VARIABLE TARJETA:
REM 1=CGA 4 COLORES (320 x 200 puntos)
REM 2=EGA 16 COLORES (640 x 350 puntos)
REM 3=EGA/VGA/SVGA 16 COLORES (320 x 200 puntos) (usarlo si va muy lento)
REM 4=MCGA 256 COLORES (320 x 200 puntos)
REM 5=VGA/SVGA 16 COLORES (640 x 480 puntos)

TARJETA = 1
GOSUB PREPARAR

REM LA VARIABLE RELAS INDICA LA RELACION DE ASPECTO DEL DISPOSITIVO DE SALIDA

RELAS = 3 / 4
IF RELAS <= 1 THEN
     REX = 480 / RELAS
     REY = 480
ELSE
     REX = 480
     REY = 480 * RELAS
END IF

RELX = XMAX / REX
RELY = YMAX / REY

REM INCR ES EL INCREMENTO DE LOS ANGULOS
REM REDUCIRLO SI VA MUY RAPIDO

INCR = 3.141592 / 18

REM D ES LA DISTANCIA DESDE EL OBSERVADOR A LA PANTALLA EN PIXELS

D = 1000

REM INICIO

REM ESTAS VARIABLES SE USAN PARA LA SIMULACION DE LA PILA O STACK
REM DEL FILL

DIM PILA(20, 1)
PUNTERO = 0

REM LEEMOS LA TABLA DE DATOS

RESTORE DATOS

REM LEEMOS LOS VERTICES

READ TOTV
DIM V(TOTV - 1, 2)
FOR N = 0 TO TOTV - 1
     FOR F = 0 TO 2
	  READ V(N, F)
     NEXT F
NEXT N

REM LEEMOS LAS CARAS

READ TOTL
DIM L(TOTL - 1, 5)
FOR N = 0 TO TOTL - 1
     READ NLIN
     L(N, 0) = NLIN
     FOR F = 1 TO NLIN + 1
	  READ L(N, F)
     NEXT F
NEXT N
    
REM AJUSTAMOS LOS COLORES SI TENEMOS UNA CGA

IF NUMCOLOR = 4 THEN
     FOR N = 0 TO TOTL - 1
	  NLIN = L(N, 0)
	  COLORES = L(N, NLIN + 1)
	  IF COLORES > 0 THEN
	       IF COLORES < 9 THEN
		    COLORES = 2
	       ELSE
		    COLORES = 3
	       END IF
	  END IF
	  L(N, NLIN + 1) = COLORES
     NEXT N
END IF

DIM MED(TOTL - 1, 1)
DIM C(TOTV - 1, 1)
RENDER = 0

REM BUCLE PRINCIPAL

FOR N = 0 TO TOTV - 1
     GOSUB ECUACION
     C(N, 0) = X
     C(N, 1) = Y
NEXT N

A$ = INKEY$
WHILE A$ <> "S" AND A$ <> "s"
     CLS
     PRINT "(C) 1994 RASTER SOFT."
    
     REM SI RENDER ES IGUAL A 1, ENTONCES ES QUE TENEMOS QUE COLOREAR
     REM LA FIGURA

     IF RENDER = 1 THEN

	  REM CALCULAMOS LA DISTANCIA DE CADA CARA Y LA ALMACENAMOS EN MED
	  REM INCLUIMOS EN MED (N,3) EL NUMERO DE CARA PARA SABER CUAL TENEMOS
	  REM QUE DIBUJAR EN CADA MOMENTO

	  PRINT "ORDENANDO LAS CARAS"
	  FOR N = 0 TO TOTL - 1
	       ZM = 0
	 
	       REM HALLAMOS LA MEDIA ARITMETICA DE LAS COORDENADAS Z
	       REM DE LOS VERTICES DE LA CARA
	  
	       LNUM = L(N, 0)
	       FOR F = 1 TO LNUM
		    ZM = ZM + V(L(N, F), 2)
	       NEXT F
	       MED(N, 0) = ZM / LNUM
	       MED(N, 1) = N
	  NEXT N
	 
	  REM ORDENAMOS LAS CARAS DE MAS LEJANA A MAS CERCANA
	  REM USANDO EL VALOR DE Z
	 
	  FOR N = 0 TO TOTL - 2
	       FOR F = N + 1 TO TOTL - 1
		    IF MED(N, 0) < MED(F, 0) THEN
			 FOR A = 0 TO 1
			      SWAP MED(N, A), MED(F, A)
			 NEXT A
		    END IF
	       NEXT F
	  NEXT N

	  LOCATE 2, 1
	  PRINT "                       "
	  FOR N = 0 TO TOTL - 1
	 
	       REM PINTAMOS LA CARA QUE INDIQUE MED (N,3)

	       CAR = MED(N, 1)
	       LNUM = L(CAR, 0)

	       REM CALCULAMOS LA MEDIA ARITMETICA DE LOS VERTICES DE LA CARA

	       XM = 0
	       YM = 0
	       FOR F = 1 TO LNUM
		    XM = XM + C(L(CAR, F), 0)
		    YM = YM + C(L(CAR, F), 1)
	       NEXT F
	       XM = XM / LNUM
	       YM = YM / LNUM
 
	       REM PINTAMOS LA CARA CON EL COLOR 1 PARA ELIMINAR
	       REM PARTES NO VISTAS

	       COLORES = 1
	       GOSUB CARA
	       X = XM * RELX
	       Y = YM * RELY
	       GOSUB FILL
	  
	       REM PINTAMOS LA CARA CON EL COLOR DEFINITIVO

	       COLORES = L(CAR, LNUM + 1)
	       GOSUB CARA
	       X = XM * RELX
	       Y = YM * RELY
	       GOSUB FILL
	 
	       REM PINTAMOS LOS BORDES DE LA CARA EN NEGRO PARA QUE RESALTEN
	       REM SOLO CON TARJETA CGA

	       IF NUMCOLOR = 4 THEN
		    COLORES = 0
		    GOSUB CARA
	       END IF
	  NEXT N
	  RENDER = 0
	 
     ELSE

	  REM SI NO SON VISTAS, LAS PINTAMOS SIMPLEMENTE

	  FOR N = 0 TO TOTL - 1
	       LNUM = L(N, 0)
	       CAR = N
	       COLORES = L(N, LNUM + 1)
	       GOSUB CARA
	  NEXT N
     END IF
    
     A$ = INKEY$
     WHILE A$ = ""
	 A$ = INKEY$
     WEND
     IF A$ = "R" OR A$ = "r" THEN RENDER = 1
     IF A$ = "A" OR A$ = "a" THEN
	  AX = INCR
	  GOSUB ROTX
     END IF
     IF A$ = "Q" OR A$ = "q" THEN
	  AX = -INCR
	  GOSUB ROTX
     END IF
     IF A$ = "P" OR A$ = "p" THEN
	  AY = INCR
	  GOSUB ROTY
     END IF
     IF A$ = "O" OR A$ = "o" THEN
	  AY = -INCR
	  GOSUB ROTY
     END IF
     IF A$ = "L" OR A$ = "l" THEN
	  AZ = INCR
	  GOSUB ROTZ
     END IF
     IF A$ = "K" OR A$ = "k" THEN
	  AZ = -INCR
	  GOSUB ROTZ
     END IF
WEND
END
   
REM CALCULAMOS LAS ROTACIONES PARA CADA UNO DE LOS VERTICES
  
ROTX:
     A$ = ""
     SA = SIN(AX)
     CA = COS(AX)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 1)
	  C2 = V(N, 2)
	  GOSUB ROTAR
	  V(N, 1) = C1
	  V(N, 2) = C2
	  GOSUB ECUACION
	  C(N, 0) = X
	  C(N, 1) = Y
     NEXT N
     AX = 0
     RETURN
       
ROTY:
     A$ = ""
     SA = SIN(AY)
     CA = COS(AY)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 0)
	  C2 = V(N, 2)
	  GOSUB ROTAR
	  V(N, 0) = C1
	  V(N, 2) = C2
	  GOSUB ECUACION
	  C(N, 0) = X
	  C(N, 1) = Y
     NEXT N
     AY = 0
     RETURN

ROTZ:
     A$ = ""
     SA = SIN(AZ)
     CA = COS(AZ)
     FOR N = 0 TO TOTV - 1
	  C1 = V(N, 0)
	  C2 = V(N, 1)
	  GOSUB ROTAR
	  V(N, 0) = C1
	  V(N, 1) = C2
	  GOSUB ECUACION
	  C(N, 0) = X
	  C(N, 1) = Y
     NEXT N
     RETURN

REM SUBRUTINA DE PROYECCION PARA PASAR DE 3D A 2D

ECUACION:
     X = (V(N, 0) * D) / (V(N, 2) + D) + REX / 2
     Y = (V(N, 1) * D) / (V(N, 2) + D) + REY / 2
     RETURN
    
REM SUBRUTINA DE ROTACION

ROTAR:
     ALFA = C1 * CA - C2 * SA
     C2 = C1 * SA + C2 * CA
     C1 = ALFA
     RETURN

REM ESTA SUBRUTINA DIBUJA CADA UNA DE LAS CARAS Y LA RELLENA

CARA:
    
     FOR F = 1 TO NLIN
	  SIGUIE = F + 1
	  IF F = LNUM THEN SIGUIE = 1
	  XI = C(L(CAR, F), 0)
	  YI = C(L(CAR, F), 1)
	  XF = C(L(CAR, SIGUIE), 0)
	  YF = C(L(CAR, SIGUIE), 1)
	  LINE (XI * RELX, YI * RELY)-(XF * RELX, YF * RELY), COLORES
     NEXT F
     RETURN

REM ESTA ES LA SUBRUTINA DE FILL
REM SI TU VERSION DE BASIC LA TIENE, CAMBIA EL GOSUB FILL POR
REM LA INSTRUCCION, CON X E Y COMO COORDENADAS INICIALES Y
REM COLORES COMO COLOR CON EL QUE RELLENAR.

FILL:
    
     HEY = 0
     PUNTERO = 0
     A = POINT(X, Y)
     WHILE (A <> COLORES OR PUNTERO > 0) AND HEY = 0
	  A = POINT(X, Y)
	  WHILE (A <> COLORES)
	       X = X - 1
	       A = POINT(X, Y)
	  WEND
	  X = X + 1
	  X1 = X
	  GOSUB TRAZAR
	  IF PUNTERO > 0 THEN
	       GOSUB SACAR
	  END IF
	  A = POINT(X, Y)
     WEND
     RETURN

TRAZAR:
     ESTADO1 = 0
     ESTADO2 = 0
     A = POINT(X1, Y)
     WHILE A <> COLORES AND X1 < XMAX AND X1 >= 0
	  A = POINT(X1, Y + 1)
	  IF A <> COLORES AND ESTADO1 = 0 THEN
	       METY = Y + 1
	       GOSUB METER
	       ESTADO1 = 1
	  END IF
	  IF A = COLORES THEN
	       ESTADO1 = 0
	  END IF
	  A = POINT(X1, Y - 1)
	  IF A <> COLORES AND ESTADO2 = 0 THEN
	       METY = Y - 1
	       GOSUB METER
	       ESTADO2 = 1
	  END IF
	  IF A = COLORES THEN
	       ESTADO2 = 0
	  END IF
	  X1 = X1 + 1
	  A = POINT(X1, Y)
     WEND
     HEY = 1
     IF X1 < XMAX AND X1 >= 0 THEN
	  LINE (X, Y)-(X1, Y), COLORES
	  HEY = 0
     END IF
     RETURN

REM ESTA SUBRUTINA METE LOS VALORES DE X1 METY EN LA PILA

METER:
     PILA(PUNTERO, 0) = X1
     PILA(PUNTERO, 1) = METY
     PUNTERO = PUNTERO + 1
     RETURN

REM ESTA SUBRUTINA SACA A LAS VARIABLES X E Y LOS VALORES DE LA PILA

SACAR:

     PUNTERO = PUNTERO - 1
     X = PILA(PUNTERO, 0)
     Y = PILA(PUNTERO, 1)
     RETURN

PREPARAR:
  
     ON TARJETA GOSUB CGA, EGA1, EGA2, MCGA, VGA
     CLS
     RETURN

CGA:
     XMAX = 320
     YMAX = 200
     SCREEN 1
     NUMCOLOR = 4
     RETURN

EGA1:
     XMAX = 640
     YMAX = 350
     SCREEN 9
     NUMCOLOR = 16
     RETURN

EGA2:
     XMAX = 320
     YMAX = 200
     SCREEN 7
     NUMCOLOR = 16
     RETURN

MCGA:
     XMAX = 320
     YMAX = 200
     SCREEN 13
     NUMCOLOR = 16
     RETURN

VGA:
     XMAX = 640
     YMAX = 480
     SCREEN 12
     NUMCOLOR = 16
     RETURN

DATOS:
     REM ESTA ES LA BASE DE DATOS OPTIMIZADA DEL CUBO.
     REM ESTA REFERIDA A UNA PANTALLA DE 640 x 480
     REM AQUI VIENE LA DEFINICION DE LOS VERTICES.
     REM EL PRIMER VALOR ES EL NUMERO DE VERTICES.
     REM CADA VERTICE VIENE DEFINIDO POR SUS TRES COORDENADAS.
    
     DATA 32
     DATA -100,-100,-100
     DATA 100,-100,-100
     DATA 100,100,-100
     DATA -100,100,-100
     DATA -100,-100,100
     DATA 100,-100,100
     DATA 100,100,100
     DATA -100,100,100
     DATA -100,-80,-80
     DATA -100,80,-80
     DATA -100,80,80
     DATA -100,-80,80
     DATA 100,-80,-80
     DATA 100,80,-80
     DATA 100,80,80
     DATA 100,-80,80
     DATA -80,-100,-80
     DATA 80,-100,-80
     DATA 80,-100,80
     DATA -80,-100,80
     DATA -80,100,-80
     DATA 80,100,-80
     DATA 80,100,80
     DATA -80,100,80
     DATA -80,-80,-100
     DATA 80,-80,-100
     DATA 80,80,-100
     DATA -80,80,-100
     DATA -80,-80,100
     DATA 80,-80,100
     DATA 80,80,100
     DATA -80,80,100

     REM AQUI VIENE LA DEFINICION DE LAS CARAS
     REM EL PRIMER NUMERO ES EL NUMERO TOTAL DE CARAS
     REM DESPUES VIENE LA DEFINICION DE ESTAS
     REM EL PRIMER VALOR ES EL NUMERO DE SEGMENTOS DE LA CARA
     REM EL ULTIMO ES EL COLOR
    
     DATA 24
     DATA 4,4,28,31,7,8
     DATA 4,4,28,29,5,9
     DATA 4,5,29,30,6,10
     DATA 4,6,30,31,7,11

     DATA 4,0,24,25,1,4
     DATA 4,0,24,27,3,5
     DATA 4,1,25,26,2,6
     DATA 4,2,26,27,3,7

     DATA 4,3,20,23,7,14
     DATA 4,3,20,21,2,15
     DATA 4,2,21,22,6,2
     DATA 4,22,6,7,23,3

     DATA 4,0,16,19,4,10
     DATA 4,0,16,17,1,11
     DATA 4,1,17,18,5,12
     DATA 4,5,18,19,4,13

     DATA 4,1,12,15,5,6
     DATA 4,1,12,13,2,7
     DATA 4,2,13,14,6,8
     DATA 4,6,14,15,5,9

     DATA 4,0,8,9,3,2
     DATA 4,0,8,11,4,3
     DATA 4,3,9,10,7,4
     DATA 4,7,10,11,4,5

