/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		PixelFormat example

	revision history:
		Jun/30/1999 - Jukka Liimatta - initial revision
		Aug/24/2001 - Jukka Liimatta - cleanup reporting
*/
#include <prcore/prcore.hpp>
#include <iostream>

using namespace prcore;
using namespace std;



int main()
{
	// palette
	Color32 palette[256];

	// PA88
	PixelFormat format0(16,palette,0xff00,0x00ff);

	// IA88
	PixelFormat format1(16,0xff00,0x00ff);

	// AI44
	PixelFormat format2(8,0x0f,0xf0);

	// BGR888
	PixelFormat format3(24,0x0000ff,0x00ff00,0xff0000,0x0);

	// stock formats
	PixelFormat format4( INTENSITY8 );
	PixelFormat format5( PALETTE8(palette) );
	PixelFormat format6( RGB565 );
	PixelFormat format7( RGB888 );
	PixelFormat format8( ARGB1555 );
	PixelFormat format9( ARGB4444 );
	PixelFormat formata( ARGB8888 );

	// compile report
	char* report1 = format4.IsIntensity() ? "I8 is intensity format." : "error";
	char* report2 = format0.IsIndexed() ? "PA88 is indexed format." : "error";
	
	// cout report
	cout << report1 << endl;
	cout << report2 << endl;

	return 0;
}
