/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		OpenGL (windowed) example

	Revision history:
		Dec/27/2000 - Edmond Cote - initial revision
*/
#define PRCORE_IMPLEMENT_MAIN
#include <prcore/prcore.hpp>
#include <GL/gl.h>

using namespace prcore;




// ===========================================================================
// window declaration
// ===========================================================================

class TestWindow : public WindowGL
{
	public:

	TestWindow(int width, int height);
	~TestWindow();

	bool		EventMain();
	void		EventDraw();
	void		EventSize(int width, int height);
	void		EventKeyboard(int keycode, bool press);
		
	private:
	
	ContextGL*	context;
	Timer		timer;
};


// ===========================================================================
// window implementation
// ===========================================================================

TestWindow::TestWindow(int width, int height)
{
	// open window
	Open(width,height,"TestWindow",WINDOW_NORMAL|WINDOW_USES3D);

	// create render context
	context = CreateContext(NULL);
	SetContext(context);
}


TestWindow::~TestWindow()
{
	DeleteContext(context);
}


bool TestWindow::EventMain()
{
	EventDraw();
	return true;
}


void TestWindow::EventDraw()
{
	// clear
	glClearColor(0.0f,0.0f,0.0f,0.0f);
	glClearDepth(1.0);
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
	
	// projection matrix
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0.0,1.0,0.0,1.0,-1.0,1.0);

	// modelview matrix	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
  
	// draw polygon
	glBegin(GL_POLYGON);
	glColor3f(1.0f,1.0f,1.0f);
	glVertex3f(0.25f,0.25f,0.0f);
	glVertex3f(0.75f,0.25f,0.0f);
	glVertex3f(0.75f,0.75f,0.0f);
	glVertex3f(0.25f,0.75f,0.0f);
	glEnd();
	
	// pageflip
	PageFlip();
}


void TestWindow::EventSize(int width, int height)
{
	glViewport(0,0,width,height);
	glScissor(0,0,width,height);
}


void TestWindow::EventKeyboard(int keycode, bool press)
{
	if ( keycode==KEYCODE_ESC && press )
		MainBreak();
}


// ===========================================================================
// prmain()
// ===========================================================================

int prmain(int argc, char** argv)
{
	TestWindow window(512,384);
	window.MainLoop();
  
	return 0;
}
