/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_CODEC_HPP
#define PRCORE_CODEC_HPP



namespace prcore
{
	
	class CodecInterface : public Interface
	{
		public:
		int			(*NumEXT)();
		const char*	(*GetEXT)(int index);
		bool		(*IsDecoder)();
		bool		(*IsEncoder)();
	};

	class BitmapCodec : public CodecInterface
	{
		public:
		bool		(*Decode)(Bitmap& target, Stream& stream);
		bool		(*Encode)(Stream& target, Surface& bitmap);
	};

	
	void			RegisterBitmapCodec(const BitmapCodec& codec);
	int				GetBitmapCodecCount();
	BitmapCodec*	GetBitmapCodec(int index);
	BitmapCodec*	FindBitmapCodec(const char* ext);

} // namespace prcore



#endif