/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_EXCEPTION_HPP
#define PRCORE_EXCEPTION_HPP



namespace prcore
{

	// declare
	class Bitmap;


	class Exception
	{
		public:

		Exception();
		Exception(const char* method, const char* message, const char* filename = NULL);
		Exception(const Exception& other);
virtual	~Exception();

		void			operator = (const Exception& other);

static	bool			SetLogo(const Bitmap& logo);	// set the user's own logo (128x94x256) for the exception dialog
		void			DrawDialog();					// draw the exception dialog
		const String&	GetFilename() const;			// file which did throw the exception
		const String&	GetMethod() const;				// method/function which did throw the exception
		const String&	GetMessage() const;				// user message attached to the exception

		private:

		String			mFilename;
		String			mMethod;
		String			mMessage;
	};


#define PRCORE_EXCEPTION(method,message) throw prcore::Exception(method,message,__FILE__);

} // namespace prcore



#endif