/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_INPUTDEVICE_HPP
#define PRCORE_INPUTDEVICE_HPP



namespace prcore
{

	class InputBase : public Interface
	{
		public:

virtual	int				GetAxisCount() const;		// get number of axis
virtual	int				GetButtonCount() const;		// get number of buttons
virtual	float			GetAxis(int index);			// get state [-1.0,1.0]
virtual	bool			GetButton(int index);		// is button pressed?

inline	bool			IsDown(int index) { return GetButton(index); }
	};


	class InputDevice : public InputBase
	{
		public:

		InputDevice();
		~InputDevice();

		int				GetAxisCount() const;
		int				GetButtonCount() const;
		float			GetAxis(int);
		bool			GetButton(int code);

		void			BindAxis(int dest, int src, InputBase&);
		void			BindButton(int dest, int src, InputBase&);

		private:

		struct BindIO
		{
			InputBase*	input;
			int			dest;
			int			src;
		};
		Array<BindIO>	axisbinds;
		Array<BindIO>	buttonbinds;

		BindIO*			FindBindIO(Array<BindIO>&, int index);
	};

} // namespace prcore



#endif