/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_STACK_HPP
#define PRCORE_STACK_HPP



namespace prcore
{

	template <class T, int SIZE>
	class Stack
	{
		public:

		Stack();
		Stack(const Stack& stack);
		~Stack();

		void		operator = (const Stack& stack);

		int			GetSize() const;
		void		Push(const T& obj);
		T&			Pop();

		private:

		T			mStackData[SIZE];
		T*			mStackPointer;
	};


template <class T, int SIZE>
inline Stack<T,SIZE>::Stack()
{
	mStackPointer = mStackData;
}


template <class T, int SIZE>
inline Stack<T,SIZE>::Stack(const Stack& stack)
{
	*this = stack;
}


template <class T, int SIZE>
inline Stack<T,SIZE>::~Stack()
{
}


template <class T, int SIZE>
inline void Stack<T,SIZE>::operator = (const Stack& stack)
{
	int size = stack.GetSize();
	mStackPointer = mStackData + size;
	for ( int i=0; i<size; i++ )
	{
		mStackData[i] = stack.mStackData[i];
	}
}


template <class T, int SIZE>
inline int Stack<T,SIZE>::GetSize() const
{
	return mStackPointer - mStackData;
}


template <class T, int SIZE>
inline void Stack<T,SIZE>::Push(const T& obj)
{
	*mStackPointer++ = obj;
}


template <class T, int SIZE>
inline T& Stack<T,SIZE>::Pop()
{
	return *--mStackPointer;
}

} // namespace prcore



#endif