/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_STRING_HPP
#define PRCORE_STRING_HPP



namespace prcore
{

	class String
	{
		public:

		String();
		String(const String& string);
		String(const char* text);
		~String();

inline	String& 	operator << (String& (__cdecl *)(String&));
inline	String& 	operator << (const char*);
inline	String& 	operator << (const unsigned char*);
inline	String& 	operator << (const signed char*);
inline	String& 	operator << (const char);
inline	String& 	operator << (const unsigned char);
inline	String& 	operator << (const signed char);
      	String& 	operator << (const short);
      	String& 	operator << (const unsigned short);
      	String& 	operator << (const int);
      	String& 	operator << (const unsigned int);
      	String& 	operator << (const long);
      	String&		operator << (const unsigned long);
     	String& 	operator << (const float);

		void		operator = (const String& string);
		void		operator = (const char* text);
		String		operator + (const String& string) const;
		String		operator + (const char* text) const;
		String&		operator += (const String& string);
		String&		operator += (const char* text);
		bool		operator == (const String& string) const;
		bool		operator == (const char* text) const;
		bool		operator != (const String& string) const;
		bool		operator != (const char* text) const;
inline	char&		operator [] (int index);
inline	const char&	operator [] (int index) const;
inline	char*		operator * ();
inline	const char*	operator * () const;
inline 				operator char* ();
inline 				operator const char* () const;

inline	int			GetLength() const;
		void 		PrintText(const char* string, ...);

		private:

		char*		mData;
		int			mLength;
	};


inline String& String::operator << ( const char* c )
{
	assert(c != NULL);
	return operator += ((const char*) c);
}

inline String& String::operator << (const unsigned char c)
{
	char t[2] = {c, 0};
	return operator += ((const char*) t);
}

inline String& String::operator << ( String& (__cdecl * _f)( String& ) )
{ 
	return( _f( *this ) ); 
}

inline String& String::operator << (const char _c)
{ 
	return operator << ( (const unsigned char) _c ); 
}

inline String& String::operator << (const signed char _c) 
{ 
	return operator << ( (const unsigned char) _c ); 
}

inline String& String::operator << (const unsigned char * _s) 
{ 
	return operator << ( (const char *) _s ); 
}

inline String& String::operator << (const signed char * _s) 
{ 
	return operator << ( (const char *) _s ); 
}

inline char& String::operator [] (int index)
{
	assert( index>=0 && index < mLength );
	return mData[index];
}

inline const char& String::operator [] (int index) const
{
	assert( index>=0 && index < mLength );
	return mData[index];
}

inline char* String::operator * ()
{
	return mData;
}

inline const char* String::operator * () const
{
	return mData;
}

inline String::operator char* ()
{ 
	return mData; 
}

inline String::operator const char* () const
{ 
	return mData; 
}

inline int String::GetLength() const
{
	return mLength;
}

} // namespace prcore



#endif