/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_CONFIGURED
#if defined( _WIN32 ) || defined( _WINDOWS_ )
#define PRCORE_CONFIGURED


	// disable warnings we do not want to see
	#if (_MSC_VER>=1000) || defined(__VISUALC__)
	#pragma warning ( disable : 4251 )
	#pragma warning ( disable : 4786 )
	#endif

	// yes, microsoft, with inline we mean inline
	#pragma inline_depth( 255 )
	#pragma inline_recursion( on )
	#pragma auto_inline( on )

	// win32 headers
	#include <windows.h>


	// platform
	#define PRCORE_PLATFORM_WIN32


	// interface
	#define PRCORE_EXPORT __declspec(dllexport)
	#define PRCORE_IMPORT __declspec(dllimport)


	// header mode
	#ifdef PRCORE_COMPILE_RUNTIME
	#define PRCORE_API PRCORE_EXPORT
	#else
	#define PRCORE_API PRCORE_IMPORT
	#endif


	// flags
	//#define PRCORE_PDB_ENDIAN
	//#define PRCORE_BIG_ENDIAN
	#define PRCORE_LITTLE_ENDIAN
	#define PRCORE_X86_SIMD


	// types
	typedef	signed char			int8;
	typedef	unsigned char		uint8;
	typedef	signed short		int16;
	typedef	unsigned short		uint16;
	typedef signed int			int32;
	typedef unsigned int		uint32;
	typedef signed __int64		int64;
	typedef unsigned __int64	uint64;


	// window handle
	struct WinHandle
	{
		HWND	hwnd;
	};


	// runtime main() declaration
	#ifdef PRCORE_IMPLEMENT_MAIN
	#include "winmain.hpp"
	#endif

	// runtime module declaration
	#ifdef PRCORE_COMPILE_RUNTIME
	#include "dllmain.hpp"
	#endif


#endif
#endif