/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_WINDOW_HPP
#define PRCORE_WINDOW_HPP



namespace prcore
{

	enum 
	{
		// window style flags
		WINDOW_MOVE			= 0x001, // window is movable
		WINDOW_SIZE			= 0x002, // window has resize button
		WINDOW_CLOSE		= 0x004, // window has close button
		WINDOW_MINIMIZE		= 0x008, // window has minimize button
		WINDOW_FRAME		= 0x010, // window has frame
		WINDOW_TITLE		= 0x020, // window has title
		WINDOW_QUITONCLOSE	= 0x040, // terminate application on close
		WINDOW_ALWAYSONTOP	= 0x080, // window is always on top
		WINDOW_USES3D		= 0x100, // window supports 3d acceleration

		// pre-defined styles
		WINDOW_FULLSCREEN	= WINDOW_QUITONCLOSE | WINDOW_USES3D,
		WINDOW_NORMAL		= 0xffffffff
	};


	class WindowBase : public Interface
	{
		public:

		WindowBase();
		~WindowBase();

		bool			Open(int width, int height, const char* name, int style);
		bool			Close();
		void			Rename(const char* name);
		void			Resize(int width, int height);
		void			Move(int x, int y);
		void			ShowCursor();
		void			HideCursor();
		void			ShowWindow();
		void			HideWindow();

		void			MainLoop();
		void			MainBreak();

virtual	bool			EventMain();
virtual	void			EventDraw();
virtual	void			EventSize(int width, int height);
virtual	void			EventKeyboard(int keycode, bool press);
virtual	void			EventFocus(bool enter);
virtual	void			EventClose();

		bool			IsOpen() const;
		int				GetStyle() const;
		WinHandle		GetHandle() const;
		Rect			GetRect() const;
		float			GetAspect() const;
		bool			IsDown(int keycode) const;
		
		void			DispatchEventKeyboard(int keycode, bool press);

		protected:

		WinHandle		mWinHandle;
		int				mWinStyle;
		
		private:

		bool			mMainBreak;
		bool			mKeyDown[256];
	};

} // namespace prcore



#endif