/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRCORE_INCLUDE_HPP
#define PRCORE_INCLUDE_HPP



// standard libraries
#include <math.h>
#include <float.h>
#include <assert.h>

// configure prcore
#include "include/win32/win32.hpp"
#include "include/linux/linux.hpp"
#include "include/beos/beos.hpp"

// configuration error
#ifndef PRCORE_CONFIGURED
#error platform not supported, e-mail: support@twilight3d.com
#endif

// prcore includes
#include "include/version.hpp"
#include "include/endian.hpp"
#include "include/integer.hpp"
#include "include/float.hpp"
#include "include/stack.hpp"
#include "include/array.hpp"
#include "include/linkedlist.hpp"
#include "include/string.hpp"
#include "include/exception.hpp"
#include "include/interface.hpp"
#include "include/stream.hpp"
#include "include/filename.hpp"
#include "include/filestream.hpp"
#include "include/memorystream.hpp"
#include "include/color32.hpp"
#include "include/pixelformat.hpp"
#include "include/rect.hpp"
#include "include/surface.hpp"
#include "include/bitmap.hpp"
#include "include/mipmap.hpp"
#include "include/alphablend.hpp"
#include "include/codec.hpp"
#include "include/cpu.hpp"
#include "include/timer.hpp"
#include "include/plugin.hpp"
#include "include/window.hpp"
#include "include/opengl.hpp"
#include "include/framebuffer.hpp"
#include "include/inputdevice.hpp"
#include "include/keyboard.hpp"
#include "include/joystick.hpp"
#include "include/mouse.hpp"



#endif