/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source: 
		cpu capabilities

	revision history:
		May/10/1998 - Jukka Liimatta - Initial revision
*/
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// flags                                           //
////////////////////////////////////////////////////

static const uint32 CPU_INIT  = ~0;
static const uint32 CPU_NONE  = 0;
static const uint32 CPU_MMX   = 0x1;
static const uint32 CPU_3DNOW = 0x2;
static const uint32 CPU_SSE   = 0x4;


//////////////////////////////////////////////////////
// extern                                          //
////////////////////////////////////////////////////

#ifdef PRCORE_X86_SIMD
extern "C"
{
	extern uint32 x86_cpu_caps();
};
#else
	static uint32 x86_cpu_caps() {return CPU_NONE;}
#endif


//////////////////////////////////////////////////////
// implementation                                  //
////////////////////////////////////////////////////

static inline uint32 cpuflags()
{
	// first time this function is called,
	// the cpu flags are queried
	static uint32 flags = CPU_INIT;
	if ( flags == CPU_INIT )
	{
		flags = x86_cpu_caps();
	}
	return flags;
}


//////////////////////////////////////////////////////
// api                                             //
////////////////////////////////////////////////////

bool prcore::IsMMX()
{
	return (cpuflags() & CPU_MMX) != 0;
}


bool prcore::IsSSE()
{
	return (cpuflags() & CPU_SSE) != 0;
}


bool prcore::Is3DNOW()
{
	return (cpuflags() & CPU_3DNOW) != 0;
}
