/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		InputDevice

	revision history:
		Jun/01/2000 - Jukka Liimatta - initial revision
		Jan/24/2001 - Jukka Liimatta - renaissance build
*/
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// InputBase                                       //
////////////////////////////////////////////////////

int InputBase::GetAxisCount() const
{
	return 0;
}


int InputBase::GetButtonCount() const
{
	return 0;
}


float InputBase::GetAxis(int index)
{
	return 0.f;
}


bool InputBase::GetButton(int index)
{
	return false;
}


//////////////////////////////////////////////////////
// InputDevice                                     //
////////////////////////////////////////////////////

InputDevice::InputDevice()
{
}


InputDevice::~InputDevice()
{
}


InputDevice::BindIO* InputDevice::FindBindIO(Array<InputDevice::BindIO>& array, int index)
{
	for ( int i=0; i<array.GetSize(); i++ )
	{
		BindIO& bind = array[i];
		if ( bind.dest == index )
		{
			return &bind;
		}
	}
	return NULL;
}


void InputDevice::BindAxis(int dest, int src, InputBase& input)
{
	Array<BindIO>& array = axisbinds;
	BindIO* ptr = FindBindIO( array, dest );

	if ( !ptr )
	{
		BindIO bind;

		bind.dest = dest;
		bind.src = src;
		bind.input = &input;

		array.PushBack( bind );
	}
	else
	{
		BindIO& bind = *ptr;

		bind.dest = dest;
		bind.src = src;
		bind.input = &input;
	}
}


void InputDevice::BindButton(int dest, int src, InputBase& input)
{
	Array<BindIO>& array = buttonbinds;
	BindIO* ptr = FindBindIO( array, dest );

	if ( !ptr )
	{
		BindIO bind;

		bind.dest = dest;
		bind.src = src;
		bind.input = &input;

		array.PushBack( bind );
	}
	else
	{
		BindIO& bind = *ptr;

		bind.dest = dest;
		bind.src = src;
		bind.input = &input;
	}
}


int InputDevice::GetAxisCount() const
{
	return int( axisbinds.GetSize() );
}


int InputDevice::GetButtonCount() const
{
	return int( buttonbinds.GetSize() );
}


float InputDevice::GetAxis(int index)
{
	BindIO* ptr = FindBindIO( axisbinds, index );
	if ( ptr )
	{
		BindIO& bind = *ptr;
		return bind.input->GetAxis( bind.src );
	}

	return 0.f;
}


bool InputDevice::GetButton(int index)
{
	BindIO* ptr = FindBindIO( buttonbinds, index );
	if ( ptr )
	{
		BindIO& bind = *ptr;
		return bind.input->GetButton( bind.src );
	}

	return false;
}
