#include <prcore/prcore.hpp>
using namespace prcore;

//////////////////////////////////////////////////////
// statics                                         //
////////////////////////////////////////////////////

void mouseMovementStaticHook(XButtonEvent *event);
void mouseButtonStaticHook(XButtonEvent *event, bool state);

static int mouseFlags = 0;
static int mouseX = 0;
static int mouseY = 0;
static long mouseStaticInitCount = 0;

Mouse::Mouse()
{        // install hook
        mouseStaticInitCount++;
}

Mouse::~Mouse()
{
        if ( mouseStaticInitCount > 0 ) mouseStaticInitCount--;
        // unhook
}

void Mouse::SetArea(const Rect& rect)
{
//      RECT clip = { rect.GetLeft(), rect.GetTop(), rect.GetRight(), rect.GetBottom() };
//      ClipCursor( &clip );
}

void Mouse::SetXY(int x, int y)
{
//      SetCursorPos( x, y );
}


int Mouse::GetX()
{
        return mouseX;
}

int Mouse::GetY()
{
        return mouseY;
}


int Mouse::NumAxis() const
{
        return 0;
}

int Mouse::NumButton() const
{
        return 3;
}


float Mouse::GetAxis(int index)
{
        return 0.f;
}
bool Mouse::GetButton(int index)
{
        switch ( index )
        {
                case MOUSE_LEFT:              return (mouseFlags & MOUSE_LEFT) != 0;
                case MOUSE_RIGHT:             return (mouseFlags & MOUSE_RIGHT) != 0;
                case MOUSE_MIDDLE:    return (mouseFlags & MOUSE_MIDDLE) != 0;
                default:                return false;
        }
}



void mouseMovementStaticHook(XButtonEvent *event)
{
  mouseX = (int)event->x;
  mouseY = (int)event->y;

  //   printf("x: %d\n",mouseX);
  //printf("y: %d\n",mouseY);

}

void mouseButtonStaticHook(XButtonEvent *event, bool state)
{

  // note reading mouse position through event loop = dick slow
  // solution?, DGAMouse access

  mouseX = (int)event->x;
  mouseY = (int)event->y;

     //note that button numbers 4 and 5 represeent mouse wheel up and down
  int button = event->button;

  //printf("button: %d\n",button);
  if(button==1)
    mouseFlags |= MOUSE_LEFT;
  else
    mouseFlags &= ( 0x0ffffff - MOUSE_LEFT );


  if(button==2)
    mouseFlags |= MOUSE_MIDDLE;
  else
    mouseFlags &= ( 0x0ffffff - MOUSE_MIDDLE );

  if(button==3)
    mouseFlags |= MOUSE_RIGHT;
  else
    mouseFlags &= ( 0x0ffffff - MOUSE_RIGHT );

  //    printf("x: %d\n",mouseX);
  //printf("y: %d\n",mouseY);

}

