/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source:
		rect implementation

	revision history:
		Feb/04/2001 - Jukka Liimatta - initial revision/renaissance build
*/
#include <prcore/prcore.hpp>
using namespace prcore;



Rect::Rect(int x0, int y0, int w, int h)
: x(x0), y(y0), width(w), height(h)
{
}


Rect::Rect(const Rect& rect)
: x(rect.x), y(rect.y), width(rect.width), height(rect.height)
{
}


float Rect::GetAspect() const
{
	return (float)width / float(height);
}


bool Rect::Intersect(const Rect& a, const Rect& b)
{
	int ax1 = a.x + a.width - 1;
	int ay1 = a.y + a.height - 1;
	int bx1 = b.x + b.width - 1;
	int by1 = b.y + b.height - 1;

	// trivial reject
	if ( ax1 < b.x ) return false; // a completely left of b
	if ( ay1 < b.y ) return false; // a completely above of b
	if ( a.x > bx1 ) return false; // a completely right of b
	if ( a.y > by1 ) return false; // a completely below of b 

	// intersecting area
	x = max(a.x,b.x);
	y = max(a.y,b.y);
	int x1 = min(ax1,bx1);
	int y1 = min(ay1,by1);

	if ( x > x1 ) return false;
	if ( y > y1 ) return false;

	width = x1 - x + 1;
	height = y1 - y + 1;

	return true;
}


bool Rect::PointInside(int px, int py)
{
	if ( px < x || px >= (x+width) ) return false;
	if ( py < y || py >= (y+height) ) return false;
	return true;
}
