/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source: 
		BitmapCodec "fxt1"

	revision history:
		Feb/21/2000 - Jukka Liimatta - initial revision
		Jan/24/2001 - Jukka Liimatta - renaissance build
*/
#include <prcore/extlib/fxt1/3dfxpb.h>
#include <prcore/extlib/fxt1/fximgpb.h>
#include <prcore/extlib/fxt1/comppb.h>
#include <prcore/extlib/fxt1/fxt1gpl.h>
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// codec                                           //
////////////////////////////////////////////////////

static int NumEXT()
{
	return 1;
}


static const char* GetEXT(int index)
{
	return "fxt1";
}


static bool IsDecoder()
{
	return true;
}


static bool IsEncoder()
{
	return false;
}


static bool Decode(Bitmap& target, Stream& stream)
{
	// reset stream
	stream.Seek(0,Stream::START);

	// read header
	CompHeader header;
	stream.Read( &header, sizeof(header) );

	// is "fxt1" stream?
	if ( header.magic != COMP_MAGIC )
		return false;

	// setup target image
	ImgInfo info;
	info.any.width = header.width;
	info.any.height = header.height;
	info.any.sizeInBytes = sizeof(FxI32) * header.width * header.height;
	info.any.data = new unsigned char[ info.any.sizeInBytes ];

	// read blocks
	int size = stream.GetSize() - sizeof(header);
	char* buffer = new char[ size ];
	stream.Read(buffer,size);

	// decode
	int verbose = 0;
	decode4x8(&info, (CCBlock*)buffer, verbose);

	// set image
	target.SetImage( header.width, header.height, PixelFormat(ARGB8888), info.any.data );

	// release
	delete[] buffer;

	return true;
}


static bool Encode(Stream& target, Surface& surface)
{
	return false;
}


//////////////////////////////////////////////////////
// factory                                         //
////////////////////////////////////////////////////

BitmapCodec CreateCodecFXT1()
{
	BitmapCodec codec;
	
	codec.NumEXT = NumEXT;
	codec.GetEXT = GetEXT;
	codec.IsDecoder = IsDecoder;
	codec.IsEncoder = IsEncoder;
	codec.Decode = Decode;
	codec.Encode = Encode;
	
	return codec;
}
