/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	Please read the file LICENSE.TXT for additional details.


	source: 
		Timer ( win32 )

	revision history:
		Jan/27/1999 - Jukka Liimatta - initial revision
*/
#include <prcore/prcore.hpp>
using namespace prcore;



//////////////////////////////////////////////////////
// Timer                                           //
////////////////////////////////////////////////////

Timer::Timer()
{
	QueryPerformanceFrequency( (LARGE_INTEGER*)&mFreq );
	QueryPerformanceCounter( (LARGE_INTEGER*)&mTime0 );
}


Timer::~Timer()
{
}


float Timer::GetTime() const
{
	int64 delta;
	QueryPerformanceCounter( (LARGE_INTEGER*)&delta );
	delta -= mTime0;

	return float( double(delta) / double(mFreq) );
}


void Timer::Reset()
{
	QueryPerformanceCounter( (LARGE_INTEGER*)&mTime0 );
}


//////////////////////////////////////////////////////
// GetTimeInfo                                     //
////////////////////////////////////////////////////

TimeInfo prcore::GetTimeInfo()
{
	SYSTEMTIME systime;
	GetLocalTime( &systime );

	TimeInfo time;

	time.year = systime.wYear;
	time.month = systime.wMonth;
	time.day = systime.wDay;
	time.hour = systime.wHour;
	time.minute = systime.wMinute;
	time.second = systime.wSecond;
	time.milliseconds = systime.wMilliseconds;

	return time;
}
