;
;                                                                      
;    Module: X86 CPU capabilities                                      
;                                                                      
;                                                                      
;    In:  -                                                            
;    Out: eax - caps_mask ( CRef: include/cpu.h )                      
;                                                                      
;                                            (C) 1999 Twilight3D, Ltd. 
;                                            http://www.twilight3d.com 
;
	
	segment .text
	
	; Export
	global _x86_cpu_caps
	global  x86_cpu_caps_
	global  x86_cpu_caps


	; In: none
	; Out: eax - processor caps bitmask
_x86_cpu_caps:
x86_cpu_caps_:
x86_cpu_caps:

	; To satisfy Linux requirements
	push    ebx
	push    edx
	
	; Test if cpu can do CPUID
	pushfd
	pop     eax
	mov     ebx, eax
	xor     eax, 0x200000
	push    eax
	popfd
	pushfd
	pop     eax
	cmp     eax, ebx
	jnz     .cpuid_found
	xor     eax, eax
	jmp     .cpu_caps_exit
.cpuid_found:

	; default: no caps
	xor     eax, eax

	; Detect MMX
	push    eax
	mov     eax, 1
	cpuid
	pop     eax
	test    edx, 0x800000
	jz      .no_mmx
	or      eax, 1  ; MMX detected.
.no_mmx:

	; Detect Streaming Simd Extensions ( SSE )
	test    edx, 0x2000000
	jz      .no_sse
	or      eax, 4  ; SSE detected.
.no_sse:

	; Detect AMD 3DNow!
	push    eax
	mov     eax, 0x80000001
	cpuid
	pop     eax
	test    edx, 0x80000000
	jz      .no_3dnow
	or      eax, 2
.no_3dnow:
.cpu_caps_exit:
	pop     edx
	pop     ebx
	ret
