/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRIMPORT_Q3MDL_HPP
#define PRIMPORT_Q3MDL_HPP



namespace primport
{

	///////////////////////////////////////////////////
	/// 	structs                                ///
	/////////////////////////////////////////////////

	struct TagQ3MDL
	{
		prcore::Array<matrix4x4f>	matrices;
	};
	
	struct VertexQ3MDL
	{
		point3f		point;
		vec3f		normal;
	};

	struct FrameQ3MDL
	{
		prcore::Array<VertexQ3MDL>	vertices;
	};

	struct FaceQ3MDL
	{
		uint16	index[3];
	};

	struct MeshQ3MDL
	{
		prcore::String				name;
		prcore::String				skin;
		prcore::Array<FrameQ3MDL>	frames;
		prcore::Array<point2f>		texcoords;
		prcore::Array<FaceQ3MDL>	faces;
	};

	
	///////////////////////////////////////////////////
	/// 	importer                               ///
	/////////////////////////////////////////////////

	class ImportQ3MDL : public prcore::Interface
	{
		public:

		prcore::Array<TagQ3MDL>		tags;
		prcore::Array<MeshQ3MDL>	meshes;

		ImportQ3MDL();
		ImportQ3MDL(prcore::Stream& stream);
		ImportQ3MDL(const char* filename);
		~ImportQ3MDL();
	};

} // namespace primport



#endif