/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRMATH_BOX_HPP
#define PRMATH_BOX_HPP



namespace prmath
{

	struct Box
	{
		Vector3		min;
		Vector3		max;

		Box() {}
		Box(const Vector3& min, const Vector3& max);

		Vector3		GetCenter() const;
		Vector3		GetSize() const;
		void		GetVertexArray8(Vector3 vertex[]) const;
	};


inline Box::Box(const Vector3& min_, const Vector3& max_)
{
	min = min_;
	max = max_;
}

inline Vector3 Box::GetCenter() const
{
	return (min + max) * 0.5f;
}

inline Vector3 Box::GetSize() const
{
	return max - min;
}

inline void Box::GetVertexArray8(Vector3 vertex[]) const
{
	Vector3* box = (Vector3*)this;

	for ( int i=0; i<8; i++ )
	{
		Vector3& v = vertex[i];
		v.x = box[i&1].x;
		v.y = box[(i&2)>>1].y;
		v.z = box[i>>2].z;
	}
}
	
} // namespace prmath



#endif