/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRMATH_INTERSECT_HPP
#define PRMATH_INTERSECT_HPP



namespace prmath
{

	bool	IntersectConeSphere(const Cone& cone, const Sphere& sphere);
	bool	IntersectBoxSphere(const Box& box, const Sphere& sphere);
	bool	IntersectRaySphere(const Line& ray, const Sphere& sphere, Vector3& point);
	bool	IntersectRaySphere(const Line& ray, const Sphere& sphere, Vector3& enter, Vector3& leave);
	bool	IntersectRayPlane(const Line& ray, const Plane& plane, Vector3& point);
	bool	IntersectRayTriangle(const Line& ray, const Vector3& v0, const Vector3& v1, const Vector3& v2, Vector3& point);
	bool	IntersectRayBox(const Line& ray, const Box& box, Vector3& point);
	bool	PlaneIntersect(const Plane& p0, const Plane& p1, Vector3& point, Vector3& direction);
	bool	PlaneIntersect(const Plane& p0, const Plane& p1, const Plane& p2, Vector3& point);
	bool	PointInsideTriangle(const Vector3& v0, const Vector3& v1, const Vector3& v2, const Vector3& point);
	float	GetTriangleArea(float edge0, float edge1, float edge2);

} // namespace prmath



#endif