/*
	Twilight Prophecy 3D/Multimedia SDK
	A multi-platform development system for virtual reality and multimedia.

	Copyright (C) 1997-2001 by Twilight 3D Finland Oy Ltd.
*/
#ifndef PRMATH_SPHERE_HPP
#define PRMATH_SPHERE_HPP



namespace prmath
{

	struct Box;


	struct Sphere
	{
		Vector3		center;
		float		radius;
		
		Sphere() {}
		Sphere(const Vector3& center, float radius);
		
		bool		Inside(const Vector3& point) const;
		void		Circumscribe(const Box& box);
	};


inline Sphere::Sphere(const Vector3& center_, float radius_)
: center(center_), radius(radius_)
{
}

inline bool Sphere::Inside(const Vector3& point) const
{
	return LengthSquared(point-center) < (radius*radius);
}

inline void Sphere::Circumscribe(const Box& box)
{
	center = box.GetCenter();
	Vector3 size = box.GetSize();
	radius = (float)(sqrt(DotProduct(size,size)) * 0.5f);
}

} // namespace prmath



#endif