#include "3dtypes.h"
#include "3dmath.h"
#include "drawer.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

tvector fustrum[4];
tvector znear_normal;
float   znear_distance;

extern float   project_dist;
extern float   project_scale;

void setup_fustrum (void)
{
  float angle_horizontal =  atan2(SX/2,project_scale)-0.0001;
  float angle_vertical  =   atan2(SY/2,project_scale)-0.0001;
  float sh     =  sin(angle_horizontal);
  float sv     =  sin(angle_vertical);
  float ch     =  cos(angle_horizontal);
  float cv     =  cos(angle_vertical);
  // left
  fustrum[0].x=ch;
  fustrum[0].y=0;
  fustrum[0].z=sh;
  // right
  fustrum[1].x=-ch;
  fustrum[1].y=0;
  fustrum[1].z=sh;
  // top
  fustrum[2].x=0;
  fustrum[2].y=cv;
  fustrum[2].z=sv;
  // bottom
  fustrum[3].x=0;
  fustrum[3].y=-cv;
  fustrum[3].z=sv;
  // near clipping plane
  znear_normal.x=0;
  znear_normal.y=0;
  znear_normal.z=1;
  // z
  znear_distance = -10;
}

struct tpointinfo {
  tvector o;
  float tx,ty;
  float c;
  float outside;
};

int inline fsgn (float a)
{
  if ( a<0 ) return -1;
  return 1;
}

void cliptoplane (const tvector plane, float distance, tpointinfo *in, int nin, tpointinfo *out, int &nout)
{
  // Dotprodukte berechnen
  for ( int i=0; i<nin; i++ ) in[i].outside = dotproduct (plane, in[i].o);
  nout = 0;
  // bis zum vorletzen Punkt berechnen:
  for ( i=0; i<nin-1; i++ ) {
    // Need no clipping
    if ( in[i].outside>=distance ) out[nout++]=in[i];
    if ( fsgn(in[i].outside-distance)!=fsgn(in[i+1].outside-distance)) {
      // need clipping
      float scale = in[i].outside/(in[i].outside-in[i+1].outside);
      tvector a = in[i].o;
      tvector b = in[i+1].o;
      out[nout].o.x=a.x+(b.x-a.x)*scale;
      out[nout].o.y=a.y+(b.y-a.y)*scale;
      out[nout].o.z=a.z+(b.z-a.z)*scale;
      nout++;
    } // endof needs clipping
  } // endof to n-1 loop
  // check last point for clipping
  if ( in[nin-1].outside>=distance ) out[nout++]=in[nin-1];
  // check last line for clipping (warp around!)
  if ( fsgn(in[0].outside-distance)!=fsgn(in[nin-1].outside-distance)) {
    // need clipping
    float scale = in[0].outside/(in[0].outside-in[nin-1].outside);
    tvector a = in[0].o;
    tvector b = in[nin-1].o;
    out[nout].o.x=a.x+(b.x-a.x)*scale;
    out[nout].o.y=a.y+(b.y-a.y)*scale;
    out[nout].o.z=a.z+(b.z-a.z)*scale;
    nout++;
  }
}

tpointinfo in[20];
tpointinfo out[20];

void clippolygondraw (fentry *p)
{
  tobject *o = p->o;
  tface f = o->face[p->fnum];
  in[0].o=o->vertice_t[f.a];
  in[0].tx=o->texx[f.a];
  in[0].ty=o->texy[f.a];
  in[0].c=o->vlight[f.a];
  in[1].o=o->vertice_t[f.b];
  in[1].tx=o->texx[f.b];
  in[1].ty=o->texy[f.b];
  in[1].c=o->vlight[f.b];
  in[2].o=o->vertice_t[f.c];
  in[2].tx=o->texx[f.c];
  in[2].ty=o->texy[f.c];
  in[2].c=o->vlight[f.c];
  int nout = 0;
  cliptoplane (znear_normal, znear_distance, in, 3, out, nout);
  cliptoplane (fustrum[1], 0, out, nout, in, nout);
  cliptoplane (fustrum[2], 0, in, nout, out, nout);
  cliptoplane (fustrum[3], 0, out, nout, in, nout);
  cliptoplane (fustrum[0], 0, in, nout, out, nout);
  polypoint2d pt[6];

  if ( nout<3 ) return;
  for ( int i=0; i<nout; i++ ) {
    pt[i].x = 65536.0*(project_scale*out[i].o.x/out[i].o.z)+(65536.0*(float)SX/2);
    pt[i].y = 65536.0*(project_scale*out[i].o.y/out[i].o.z)+(65536.0*(float)SY/2);
    pt[i].c = p->color;
  }
  DrawPoly (pt, nout);
}


