#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <math.h>

#include "3dmath.h"
#include "3dtypes.h"
#include "3dclip.h"
#include "mouse.h"
#include "fps.h"
#include "drawer.h"

int polyvis = 0;
int polyinvis = 0;

tvector light;
float   project_dist;
float   project_scale;
tvector nullvector = {0,0,0};

tobject::tobject (void)
{
  cullpoint =  NULL;
  face =       NULL;
  vertice =    NULL;
  vertice_t =  NULL;
  normal =     NULL;
  vtransinfo = NULL;
  texx =       NULL;
  texy =       NULL;
  childs =     NULL;
  next   =     NULL;
  parent =     NULL;
  flags  =     0;
  nfaces =     0;
  nvertices =  0;
}

tobject::tobject (char *name)
{
  flags = OBJFLAG_VISIBLE;
  printf ("Load Object %s\n", name);
  FILE *f = fopen (name, "rt");
  printf ("Get size\n");
  fscanf (f, "%i %i\n", &nvertices, &nfaces);
  printf ("Alloc Object Memory\n");
  cullpoint = new float[nfaces];
  face =      new tface[nfaces];
  vertice =   new tvector[nvertices];
  vertice_t = new tvector[nvertices];
  normal =    new tvector[nfaces];
  vlight =    new int[nvertices];
  vnormal =   new tvector[nvertices];
  vtransinfo = new char[nvertices];
  texx = new int[nvertices];
  texy = new int[nvertices];
  // vertices lesen
  float tx, ty;
  for ( int i=0; i<nvertices; i++ )
  {
    fscanf (f, "%f %f %f %f %f\n", &vertice[i].x, &vertice[i].y, &vertice[i].z, &tx, &ty);
    printf ("read vertice %i\r", i);
    texx[i]=tx*256.0;
    texy[i]=ty*256.0;
  }
  // faces lesen
  for ( i=0; i<nfaces; i++ )
  {
    fscanf (f, "%i %i %i", &face[i].a, &face[i].b, &face[i].c);
    printf ("read face %i\r", i);
  }
  fclose (f);
  setscale (1,1,1);
  settrans (0,0,0);
  setrot   (0,0,0);
  calc_facenormals();
  calc_vertnormals();
  calc_boundarybox();
  memset (vtransinfo, 0, nvertices);
  childs = NULL;
  next   = NULL;
  parent = NULL;
}

void tobject::linkchild (tobject *childobj)
{
  // Link an object into the childlist
  childobj->next = childs;
  childobj->parent = this;
  childs=childobj;
}

void tobject::unlinkchild (tobject *childobj)
{
  // Unlink an object from the childlist
  tobject *last = NULL;
  for ( tobject *run=childs; run; run=run->next ) {
    if ( run==childobj ) {
      if ( last ) last->next = run->next;
      else childs=run->next;
      run->parent=NULL;
      run->next=NULL;
      return;
    }
    last=run;
  }
}

void tobject::unlink (void)
{
  if ( parent ) parent->unlinkchild(this);
}

tobject::~tobject(void)
{
  if (face)       delete [] face;
  if (vertice)    delete [] vertice;
  if (vertice_t)  delete [] vertice_t;
  if (vtransinfo) delete [] vtransinfo;
  if (cullpoint)  delete [] cullpoint;
  if (texx)       delete [] texx;
  if (texy)       delete [] texy;
  if (normal)     delete [] normal;
  if (vlight )    delete [] vlight;
  if (vnormal )   delete [] vnormal;
}

void tobject::calc_facenormals (void)
{
  for ( int i=0; i<nfaces; i++ ) {
    tvector a,b,c;
    a= vertice[face[i].a];
    b= vertice[face[i].b];
    c= vertice[face[i].c];
    tvector u;
    tvector v;
    u.x=a.x-b.x;    u.y=a.y-b.y;    u.z=a.z-b.z;
    v.x=a.x-c.x;    v.y=a.y-c.y;    v.z=a.z-c.z;
    crossproduct (u, v, normal[i]);
    normvector (normal[i]);
    cullpoint[i]=dotproduct (normal[i], a);
  }
}

void tobject::calc_vertnormals (void)
{
  for (int i=0; i<nvertices; i++) {
    int found=0;
    vnormal[i].x=0;
    vnormal[i].y=0;
    vnormal[i].z=0;
    for (int n=0; n<nfaces; n++) {
      if ( face[n].a==i ) {
        found++;
        vnormal[i].x+=normal[n].x;
        vnormal[i].y+=normal[n].y;
        vnormal[i].z+=normal[n].z;
      }
      if ( face[n].b==i ) {
        found++;
        vnormal[i].x+=normal[n].x;
        vnormal[i].y+=normal[n].y;
        vnormal[i].z+=normal[n].z;
      }
      if ( face[n].c==i ) {
        found++;
        vnormal[i].x+=normal[n].x;
        vnormal[i].y+=normal[n].y;
        vnormal[i].z+=normal[n].z;
      }
    }
   if (found==0) {
     printf ("degenrated vertice found\n");
     exit(1);
   }
   normvector (vnormal[i]);
  }
}

void tobject::calc_boundarybox (void)
{
  float minx=1e20;   float maxx=1e20;   float miny=1e20;
  float maxy=-1e20;  float minz=-1e20;  float maxz=-1e20;
  for ( int i=0; i<nvertices; i++ ) {
    if ( vertice[i].x<minx) minx=vertice[i].x;
    if ( vertice[i].y<miny) miny=vertice[i].y;
    if ( vertice[i].z<minz) minz=vertice[i].z;
    if ( vertice[i].x>maxx) maxx=vertice[i].x;
    if ( vertice[i].y>maxy) maxy=vertice[i].y;
    if ( vertice[i].z>maxz) maxz=vertice[i].z;
  }
  boundary[0].x=minx;  boundary[0].y=miny;  boundary[0].z=minz;
  boundary[1].x=maxx;  boundary[1].y=miny;  boundary[1].z=minz;
  boundary[2].x=minx;  boundary[2].y=maxy;  boundary[2].z=minz;
  boundary[3].x=maxx;  boundary[3].y=maxy;  boundary[3].z=minz;
  boundary[4].x=minx;  boundary[4].y=miny;  boundary[4].z=maxz;
  boundary[5].x=maxx;  boundary[5].y=miny;  boundary[5].z=maxz;
  boundary[6].x=minx;  boundary[6].y=maxy;  boundary[6].z=maxz;
  boundary[7].x=maxx;  boundary[7].y=maxy;  boundary[7].z=maxz;
}

void tobject::setrot (float x, float y, float z)
{
  tvector v;
  v.x=x;  v.y=y;  v.z=z;
  make_rotation_matrix (mrot, v);
  make_inverse_rotation_matrix (mirot, v);
}

void tobject::setscale (float x, float y, float z)
{
  tvector v;
  v.x=x;
  v.y=y;
  v.z=z;
  make_scale_matrix (mscale, v);
}

void tobject::settrans (float x, float y, float z)
{
  tvector v;
  v.x=x;  v.y=y;  v.z=z;
  make_move_matrix (mtrans, v);
}

void tobject::build_ltm (void)
{
  matrix_mul (ltm, mrot, mscale);
  ltm[3]=mtrans[3];
  ltm[7]=mtrans[7];
  ltm[11]=mtrans[11];
  if ( parent ) {
    // Objekt hat einen Parent, also die Transformation mit einbeziehen!
    matrix_mul (iltm, ltm, parent->ltm);
    memcpy (ltm, iltm, 16*sizeof (float));
    matrix_mul (iltm, parent->mirot, mirot);
    memcpy (mirot, iltm, 16*sizeof (float));
  }
  angle_preserving_matrix_inverse (ltm, iltm);
}

void tobject::putfaces (fentry *list, int &max)
{
  build_ltm();
  if ( !(flags&OBJFLAG_VISIBLE) ) return;
  int object_max = max;
  /*-----------------04-11-97 02:23pm-----------------
   * Light Calculation: FACES
   * --------------------------------------------------*/
  tvector local_light;
  transform (light, mirot, local_light);
  /*-----------------04-11-97 02:23pm-----------------
   * Backface Culling
   * --------------------------------------------------*/
  tvector local_orientation=nullvector;
  local_orientation.z=-project_dist;
  transform (local_orientation, iltm, local_orientation);
  for ( int i=0; i<nfaces; i++ ) {
   if ( dotproduct (normal[i], local_orientation) >= cullpoint[i]) {
      // mark vertices which needs to be rotated
      vtransinfo[face[i].a]++;
      vtransinfo[face[i].b]++;
      vtransinfo[face[i].c]++;
      // remember which face is visible;
      list[object_max++].fnum=i;
    }
  }
  /*-----------------04-11-97 02:23pm-----------------
   * Vertice Transformation
   * --------------------------------------------------*/
  for ( i=0; i<nvertices; i++ )
  if (vtransinfo[i]) {
    vtransinfo[i]=0;
    transform (vertice[i], ltm, vertice_t[i]);
    vertice_t[i].z+=project_dist;
    // Goraud-Shading Calculation
    vlight[i] = colorbase+((dotproduct (vnormal[i], local_light)*(colorwidth>>1)+(colorwidth>>1)));
  }
  /*-----------------04-11-97 05:10pm-----------------
   * Prepeare the polygons to be drawed
   * --------------------------------------------------*/
  for ( i=max; i<object_max; i++ ) {
    list[i].o = this;
    tface *f = &face[list[i].fnum];
    list[i].z = vertice_t[f->a].z+
                vertice_t[f->b].z+
                vertice_t[f->c].z;
    list[i].color = colorbase+((dotproduct (normal[list[i].fnum], local_light)*(colorwidth>>1)+(colorwidth>>1)));
  }
  polyvis += (object_max-max);
  polyinvis += (nfaces - (object_max-max));
  max = object_max;
  // verkettete Objekte auch mitzeichnen
  if ( next ) next->putfaces(list, max);
  // Child Objekte auch mitzeichnen
  if ( childs) childs->putfaces(list, max);
}

int cmpproc (const void *op1, const void *op2)
{
  float a= (*(fentry *) op1).z;
  float b= (*(fentry *) op2).z;
  if ( a>b ) return -1;
  if ( a<b ) return 1;
  return 0;
}

fentry sortlist[8192];

void draw_list (int maxface)
{
  qsort (sortlist, maxface, sizeof (fentry), cmpproc);
  for ( int i=0; i<maxface; i++ )
    clippolygondraw (&sortlist[i]);
}

void main (void)
{
  tobject *gabel = new tobject ("rad.3d");

  init_graphics();

  gabel->setscale (2, 2, 2);
  gabel->settrans (0, 0, 100);
  gabel->colorbase=0;
  gabel->colorwidth=255;

  // setup light
  tvector templight;
  templight.x = 0;
  templight.y = 0;
  templight.z = -60;

  // setup perspective
  project_scale = 256;
  project_dist  = 256;
  setup_fustrum ();

  short int dx, dy;
  char ch;
  start_fps ();
  float anglex=0;
  float angley=0;
  float anglez=0;
  float posx=0;
  float posy=0;
  float oscale = 2;
  do {
    // do some interaction (mouse+kb)
    Mouse_Move (dx, dy);
    if ( Mouse_Buttons()==1 ) {
      anglex+=(float)dy/100.0;
      angley+=(float)dx/100.0;
    }
    if (Mouse_Buttons()==2) {
      posx+=dx;
      posy+=dy;
    }
    templight.x+=dx;
    templight.y+=dy;
    light= templight;
    normvector (light);

    if ( kbhit() ) {
      ch = getch();
      switch ( ch ) {
        case 'q': anglex-=0.1; break;
        case 'w': anglex+=0.1; break;
        case 'a': angley-=0.1; break;
        case 's': angley+=0.1; break;
        case 'y': anglez-=0.1; break;
        case 'x': anglez+=0.1; break;
        case '1': project_dist-=10; break;
        case '2': project_dist+=10; break;
        case '3': project_scale-=10; setup_fustrum(); break;
        case '4': project_scale+=10; setup_fustrum(); break;
      }
    }
    anglex+=0.003;
    angley-=0.005;
    anglez+=0.007;
    gabel->setrot (-anglex, -angley, -anglez);
    gabel->settrans (posx, posy, 400);
    gabel->setscale (oscale, oscale, oscale);
    int max=0;
    gabel->putfaces (sortlist, max);

    start_frame();
    draw_list (max);
    end_frame();

    inc_frames ();
  } while ( ch!=27);

  end_fps ();
  done_graphics();
  report_fps ();
  float pv = polyvis;
  float pi = polyinvis;
  printf ("%3.2f%% of the faces are visible\n", pv*100.0/(pi+pv));
}


