#ifndef __3dtypes_h
#define __3dtypes_h

#define FALSE 0
#define TRUE 1

struct polypoint2d {
  float x;
  float y;
  float c;   //  goraud-shading
};

struct tvector {
  float x,y,z;
};

struct tface {
  int a,b,c;
};

struct fentry {
  struct tobject *o;
  int fnum;
  float z;
  char color;
};

class tobject {
  // orientation info
  float   mrot[16];       // Rotation Matrix
  float   mtrans[16];     // Translation Matrix
  float   mscale[16];     // Scale Matrix
  float   mirot[16];      // Reversed Rotation Matrix
  float   ltm[16];        // local transformation matrix
  float   iltm[16];
  void    build_ltm (void);
  void    calc_facenormals (void);
  void    calc_vertnormals (void);
  void    calc_boundarybox (void);
  // Hirachie Info
  tobject *childs;
  tobject *next;
  tobject *parent;
public:
  // boundary information
  tvector boundary[8];
  // shading and style flags
  unsigned int flags;     // Object Flags
  // geometry info
  int     nfaces;         // Number of Faces
  int     nvertices;      // Number of Vertices
  tface   *face;          // Face-List
  tvector *normal;        // Face Normal-Vectors
  tvector *vnormal;       // vertice Normal-Vectors
  tvector *vertice;       // Vertices
  char    *vtransinfo;    // info which vertices needs to be transformed
  float   *cullpoint;     // normal.vertice_a
  int     *texx;          // x-texture
  int     *texy;          // y-texture
  int     *vlight;        // Goraud-Shading Vertice Light
  tvector *vertice_t;     // transformed Vertices
  // shading info
  int      colorbase;     // Shading Base color
  int      colorwidth;    // Width of Color Sweep
  tobject  (char *name);
  tobject  (void);
  ~tobject (void);
  void putfaces (fentry * list, int &max);
  void setrot   (float x, float y, float z);
  void setscale (float x, float y, float z);
  void settrans (float x, float y, float z);
  void linkchild (tobject *childobj);   // link a childobject
  void unlinkchild (tobject *childobj); // unlink a childobject
  void unlink (void);                   // unlink object if child
};

// FLAG DEFINITIONS:

#define OBJFLAG_VISIBLE      0x0001
#define OBJFLAG_CULLING      0x0002
#define OBJFLAG_FACELIGHT    0x0004
#define OBJFLAG_VERTLIGHT    0x0008
#define OBJFLAG_TEXTURE      0x0010

#define OBJFLAGS_DUMMY         0
#define OBJFLAGS_FLAT          (OBJFLAG_VISIBLE|OBJFLAG_CULLING|OBJFLAG_FACELIGHT)
#define OBJFLAGS_GORAUD        (OBJFLAG_VISIBLE|OBJFLAG_CULLING|OBJFLAG_VERTLIGHT)
#define OBJFLAGS_TEXTURED      (OBJFLAG_VISIBLE|OBJFLAG_CULLING|OBJFLAG_TEXTURE)
#define OBJFLAGS_TEXTURFLAT    (OBJFLAG_VISIBLE|OBJFLAG_CULLING|OBJFLAG_TEXTURE|OBJFLAG_FACELIGHT)
#define OBJFLAGS_TEXTURGORAUD  (OBJFLAG_VISIBLE|OBJFLAG_CULLING|OBJFLAG_TEXTURE|OBJFLAG_VERTLIGHT)

#endif
