/*-----------------05-12-97 06:14pm-----------------
 * Graphic Port File
 * Add your custom graphic-routines here (and only here)
 * --------------------------------------------------*/

#include "drawer.h"
#include <stdlib.h>
#include "3dtypes.h"
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include "mode13.h"
#include "flatpoly.h"

// Screen-Sizes!
long SX;
long SY;
static int vidpage;
char *vscreen;
char *VIDEO;


void init_graphics (void)
{
  SX = 320;
  SY = 240;
  VIDEO = (char *) 0xa0000;
  Mode13();
  vscreen = (char *) malloc (SX*SY);
  ColorBlend (0, 0, 0, 0, 255, 63, 63, 63);
}

void done_graphics(void)
{
  TextMode();
  free (vscreen);
}

void start_frame(void)
{
  memset (vscreen, 0, SX*SY);
}

void end_frame(void)
{
  memcpy (VIDEO, vscreen, SX*SY);
}

void DrawPoly (polypoint2d *point, int n)
{
  flatpunkt p[6];
  for ( int i=0; i<n; i++ ) {
    p[i].x=(float)point[i].x;
    p[i].y=(float)point[i].y;
  }
  if ( n>=3 ) {
    DrawFlatPolygon(3, p, point[0].c);
    if ( n>=4 ) {
      p[1]=p[2];
      p[2]=p[3];
      DrawFlatPolygon(3, p, point[0].c);
      if ( n>=5 ) {
        p[1]=p[2];
        p[2]=p[4];
        DrawFlatPolygon(3, p, point[0].c);
        if ( n>=6 ) {
          p[1]=p[2];
          p[2]=p[5];
          DrawFlatPolygon(3, p, point[0].c);
        }
      }
    }
  }
}





