#include <limits.h>
#include "flatpoly.h"
#include <string.h>
#include <stdlib.h>

//#define debug
//#define showedge
//#define manual
#define subpixel

#define scrwidth 320

int minx[201];
int maxx[201];

long maxix,maxiy,minix,miniy,scline,tom;
long v1x,v1y, v2x,v2y, v3x,v3y;
unsigned long scroffsl, scroffsr;

extern char * vscreen;

char drawline(flatpunkt *p1, flatpunkt *p2, char color)
{
  (vscreen+p1->x+p1->y*scrwidth)[0]=255;
  (vscreen+p2->x+p2->y*scrwidth)[0]=255;
  if (p1->y>p2->y) {
    flatpunkt *test;
    test=p2;
    p2=p1;
    p1=test;
  }
  long scrziel=(long) (vscreen+p2->x+p2->y*scrwidth);

  int dx = p2->x-p1->x;
  if (dx<0) dx--;
  else dx++;

  int dy = p2->y-p1->y+1;                    // deltay
  char *scradr=vscreen+p1->x+p1->y*scrwidth; // screenadr of p1
  char *scradrs=scradr;
  long addx=(dx<<16)/(dy);   // dx / count of scanlines
  int x=p1->x<<16;
  if (dx<0) x+=1<<16;
   else x-=1<<16;
  x+=32768;
  int y=p1->y;
  int scanline=0;
  for (scanline=0; scanline<dy; scanline++) {
    x+=addx+1;
    scradr=vscreen+(x>>16)+y*scrwidth;
/*
    if (scradrs<=scradr)
      memset(scradrs,color,(int) abs(scradr-scradrs)+1);
    else
      memset(scradr,color,(int) abs(scradrs-scradr)+1);
*/
    memset(scradr, 72, 1);
    y++;
    scradrs+=scrwidth;
  }
  if ((long) scradr !=scrziel) return 0;
   else return 1;
}

#ifdef subpixel
void DrawFlatPolygon(int numverts, flatpunkt *vertice, char color)
{
#ifdef debug
  static char draw=1;
  if (!draw) return;
#endif
// return;
#ifdef showedge
  char setp=0;
  for (setp=0; setp<3; setp++)
    (vscreen+(vertice[setp].x>>16)+(vertice[setp].y>>16)*scrwidth)[0]=255;
#endif

  char top=0, left=1, right=2, middle, bottom;
  unsigned int top_middle, top_bottom;

  // find the top vertex !!!
  if (vertice[top].y>vertice[left ].y) top=left;
  if (vertice[top].y>vertice[right].y) top=right;
  // since the vertices are sorted in counter clockwise order, it's easy to
  // find right and left vertices of top vertice
  left = (top==2) ? 0 : top+1;
  right= (top==0) ? 2 : top-1;

  long deltax_right = vertice[right].x-vertice[top].x;
  long deltay_right = (vertice[right].y&~65535) - (vertice[top].y&~65535)>>16;
  long deltax_left  = vertice[left].x-vertice[top].x;
  long deltay_left  = (vertice[left] .y&~65535) - (vertice[top].y&~65535)>>16;

  if (deltay_left<=deltay_right) {
    middle=left; bottom=right;
    top_middle = deltay_left;
    top_bottom = deltay_right;
  }
  else {
    middle=right; bottom=left;
    top_middle = deltay_right;
    top_bottom = deltay_left;
  }

  if (deltay_right==0) { deltay_right=1;  }
  if (deltay_left==0)  { deltay_left=1; }
  if (deltay_right<=0) { return;  }
  if (deltay_left<=0)  { return; }

  unsigned long adderx_right = deltax_right/deltay_right;
  unsigned long adderx_left  = deltax_left/deltay_left;

  unsigned long scroffsx_right = vertice[top].x;
  unsigned long scroffsx_left  = scroffsx_right;
  unsigned long scroffsy       = (unsigned long) vscreen+(vertice[top].y>>16)*scrwidth;

  int scanline=0;
  while (scanline<top_bottom) {
    if (scanline==top_middle) {
      long deltay = (vertice[bottom].y&~65535)-(vertice[middle].y&~65535)>>16;
      if (!deltay) break; // return;
      long deltax = vertice[bottom].x-vertice[middle].x;
      if (middle==left) {
        scroffsx_left = vertice[middle].x;
        adderx_left = deltax/deltay;
      }
      else {
        scroffsx_right = vertice[middle].x;
        adderx_right = deltax/deltay;
      }
    }

    scroffsx_right+= adderx_right;
    scroffsx_left += adderx_left;
    scroffsy      += scrwidth;
    if ((scroffsx_right>>16)>=(scroffsx_left>>16))
      memset((char* ) scroffsy+(scroffsx_left>>16), color, (scroffsx_right>>16)-(scroffsx_left>>16)+1);
#ifndef debug
    else
//      return;
      memset((char *) scroffsy+(scroffsx_right>>16), color, (scroffsx_left>>16)-(scroffsx_right>>16)+1);
#endif
#ifdef debug
    else
    {
      v1x = vertice[0].x;
      v1y = vertice[0].y;
      v2x = vertice[1].x;
      v2y = vertice[1].y;
      v3x = vertice[2].x;
      v3y = vertice[2].y;
      scline=scanline;
      scroffsl=scroffs_left;
      scroffsr=scroffs_right;
      draw=0;
      return;
    }
#endif
    scanline++;
  }
#ifdef showedge
  for (setp=0; setp<3; setp++)
    (vscreen+(vertice[setp].x>>16)+(vertice[setp].y>>16)*scrwidth)[0]=255;
#endif
}
#endif

#ifndef subpixel
void DrawFlatPolygon(int numverts, flatpunkt *vertice, char color)
{
#ifdef debug
  static char draw=1;
  if (!draw) return;
#endif
/*
  flatpunkt vertice[3];

  vertice[0].x=80;
  vertice[0].y=90;
  vertice[1].x=160;
  vertice[1].y=190;
  vertice[2].x=240;
  vertice[2].y=90;

  vertice[0].x=184;
  vertice[0].y=96;
  vertice[1].x=147;
  vertice[1].y=98;
  vertice[2].x=160;
  vertice[2].y=97;

  drawline(&vertice[0], &vertice[1], color);
*/
#ifdef showedge
  char setp=0;
  for (setp=0; setp<3; setp++)
    (vscreen+vertice[setp].x+vertice[setp].y*scrwidth)[0]=255;
#endif

  char top=0, left=1, right=2, middle, bottom;
  unsigned int top_middle, top_bottom;

  // find the top vertex !!!
  if (vertice[top].y>vertice[left ].y) top=left;
  if (vertice[top].y>vertice[right].y) top=right;
  // since the vertices are sorted in counter clockwise order, it's easy to
  // find right and left vertices of top vertice
  left = (top==2) ? 0 : top+1;
  right= (top==0) ? 2 : top-1;

  long deltax_right = vertice[right].x - vertice[top].x;
  long deltay_right = vertice[right].y - vertice[top].y;
  long deltax_left = vertice[left] .x - vertice[top].x;
  long deltay_left = vertice[left] .y - vertice[top].y;

  if (deltay_left<=deltay_right) {
    middle=left; bottom=right;
    top_middle = deltay_left;
    top_bottom = deltay_right;
  }
  else {
    middle=right; bottom=left;
    top_middle = deltay_right;
    top_bottom = deltay_left;
  }

  if (deltay_right==0) { deltay_right=1;  }
  if (deltay_left==0)  { deltay_left=1; }
  if (deltay_right<=0) { return;  }
  if (deltay_left<=0)  { return; }

  unsigned long adderx_right = (deltax_right<<16)/deltay_right;
  unsigned long adderx_left = (deltax_left<<16)/deltay_left;

  unsigned long scroffs_right = (vertice[top].x+vertice[top].y*scrwidth)<<16;
  unsigned long scroffs_left  = scroffs_right;
  scroffs_right+=32768;
  scroffs_left+=32768;
//  scroffs_left-=1;

  int scanline=0;
  while (scanline<top_bottom) {
//  while (scanline<top_middle) {
    if (scanline==top_middle) {
      long deltay = vertice[bottom].y-vertice[middle].y;
      if (!deltay) break; // return;
      long deltax = vertice[bottom].x-vertice[middle].x;
      if (middle==left) {
        scroffs_left = vertice[middle].x+vertice[middle].y*scrwidth<<16;
        scroffs_left+= 32768;
        adderx_left = (deltax<<16)/deltay;
      }
      else {
        scroffs_right = vertice[middle].x+vertice[middle].y*scrwidth<<16;
        scroffs_right+= 32768;
        adderx_right = (deltax<<16)/deltay;
      }
    }

    scroffs_right+= (scrwidth<<16) + adderx_right;
    scroffs_left += (scrwidth<<16) + adderx_left;
//    if (abs(scroffs_right-scroffs_left)>>16<scrwidth)
      if ((scroffs_right>>16)>=(scroffs_left>>16))
        memset(vscreen+(scroffs_left>>16), color, (scroffs_right>>16)-(scroffs_left>>16));
#ifndef debug
      else
        memset(vscreen+(scroffs_right>>16), color, (scroffs_left>>16)-(scroffs_right>>16));
#endif
#ifdef debug
      else
      {
        v1x = vertice[0].x;
        v1y = vertice[0].y;
        v2x = vertice[1].x;
        v2y = vertice[1].y;
        v3x = vertice[2].x;
        v3y = vertice[2].y;
        scline=scanline;
        scroffsl=scroffs_left;
        scroffsr=scroffs_right;
        draw=0;
        return;
      }
#endif
    scanline++;
  }
#ifdef showedge
  for (setp=0; setp<3; setp++)
    (vscreen+vertice[setp].x+vertice[setp].y*scrwidth)[0]=255;
#endif
}
#endif
void DrawFlatPolygondamn(int numverts, flatpunkt *vertice, char color)
{
  char top=0, left=1, right=2;
/*
  for (char setp=0; setp<3; setp++) {
    (vscreen+vertice[setp].x+vertice[setp].y*scrwidth)[0]=255;
    drawline(&vertice[0], &vertice[1],color);
    drawline(&vertice[1], &vertice[2],color);
    drawline(&vertice[2], &vertice[0],color);

  }
  return;
*/
  /*
  if (color<1) color=255;
  for (char loop=0; loop<3; loop++) {
    long vertx=vertice[loop].x;
    long verty=vertice[loop].y;
    for (char test=0; test<3; test++) {
      if (test!=loop)
        if ((vertx==vertice[test].x) && (verty==vertice[test].y))
          color=255;
    }
  }
  */

  // find highest vertice on screen
  if (vertice[top].y>vertice[left].y) top=left;
  if (vertice[top].y>vertice[right].y) top=right;
  // set left and right vertice (sorted counter clockwise)
  left=(top==2)?0:top+1;
  right=(top==0)?2:top-1;

  char *scradrl=(char *) (vertice[top].x+vertice[top].y*scrwidth<<16);
  char *scradrr=scradrl;


  long dxl=vertice[left].x-vertice[top].x;
  long dyl=vertice[left].y-vertice[top].y;
  long dxr=vertice[right].x-vertice[top].x;
  long dyr=vertice[right].y-vertice[top].y;

  if ((dyl<0) || (dyr<0)) color=255;
  unsigned long edgeaddx[3];

//  if ((!dyl) || (!dyr)) return;
  char fmid=0;
  if (dyl==0) {
    fmid=1;
    edgeaddx[left]=dxl<<16;
  } else edgeaddx[left]=(dxl<<16)/dyl;

  if (dyr==0) {
    fmid=1;
    edgeaddx[right]=dxr<<16;
  } else edgeaddx[right]=(dxr<<16)/dyr;

  unsigned int tomid, tobot, count, scanline=0;
  tomid = (dyr>=dyl) ? dyl : dyr;
  tobot = (dyr>=dyl) ? dyr : dyl;

  for (; scanline<tobot; scanline++) {
      scradrl+=edgeaddx[left];
      scradrr+=edgeaddx[right];
      if (scradrl<=scradrr)
        memset(((unsigned long) scradrl-1>>16)+vscreen, color, abs(((unsigned long) scradrr>>16)-((unsigned long) scradrl>>16))+1);
      else
//        scanline=tobot;
        memset(((unsigned long) scradrr-1>>16)+vscreen, color, abs(((unsigned long) scradrr>>16)-((unsigned long) scradrl>>16))+1);
    if (scanline==(tomid-1)) fmid=1;
    if (fmid) {
      long dy=vertice[right].y-vertice[left].y;
      if (!dy) return;
      long dx=vertice[right].x-vertice[left].x;
      char side=(vertice[left].y<=vertice[right].y) ? left : right;
      edgeaddx[side]=(dx<<16)/dy;
/*
      if (side==left)
        scradrl=(char *) (vertice[side].x+(vertice[side].y-1)*scrwidth<<16)+32768;
      if (side==right)
        scradrr=(char *) (vertice[side].x+(vertice[side].y-1)*scrwidth<<16)+32768;
*/
      fmid=0;
    }
    scradrl+=scrwidth<<16;
    scradrr+=scrwidth<<16;
  }
}

void DrawFlatPolygonfix(int numverts, flatpunkt *vertice, char color)
{
/*
  for (char z=0; z<3; z++) {
    vertice[z].x<<=16;
    vertice[z].y<<=16;
  }
*/
/*
  for (z=0; z<3; z++) {
    vertice[z].x>>=16;
    vertice[z].y>>=16;
  }
  DrawFlatPolygonfix(numverts, vertice, color);
  return;
*/

  char top=0, left=1, right=2;

  // find highest vertice on screen
  if (vertice[top].y>vertice[left].y) top=left;
  if (vertice[top].y>vertice[right].y) top=right;
  // set left and right vertice (sorted counter clockwise)
  left=(top==2)?0:top+1;
  right=(top==0)?2:top-1;

  char *scradrl=(char *) (vertice[top].x+((vertice[top].y>>16)*scrwidth<<16));
  char *scradrr=scradrl;
//  memset( vscreen+((unsigned long)scradrl>>16), 255, 1);

  long dxl=vertice[left].x-vertice[top].x;
  long dyl=vertice[left].y-vertice[top].y;
  long dxr=vertice[right].x-vertice[top].x;
  long dyr=vertice[right].y-vertice[top].y;

  unsigned long edgeaddx[3];

//  if ((!dyl) || (!dyr)) return;
  char fmid=0;
  if ((dyl>>16)==0) {
    fmid=1;
    edgeaddx[left]=dxl;
  } else edgeaddx[left]=dxl/(dyl>>16);

  if ((dyr>>16)==0) {
    fmid=1;
    edgeaddx[right]=dxr;
  } else edgeaddx[right]=dxr/(dyr>>16);

  unsigned int tomid, tobot, count, scanline=0;
  tomid = (dyr>=dyl) ? (dyl>>16) : (dyr>>16);
  tobot = (dyr>=dyl) ? (dyr>>16) : (dyl>>16);

  for (; scanline<tobot; scanline++) {
    scradrl+=edgeaddx[left];
    scradrr+=edgeaddx[right];
    if (scradrl<=scradrr)
      memset(((unsigned long) scradrl>>16)+vscreen, color, abs(((unsigned long) scradrr>>16)-((unsigned long) scradrl>>16))+1);
    else
      memset(((unsigned long) scradrr>>16)+vscreen, color, abs(((unsigned long) scradrr>>16)-((unsigned long) scradrl>>16))+1);
    if (scanline==(tomid-1)) fmid=1;
    if (fmid) {
      long dx=vertice[right].x-vertice[left].x;
      long dy=vertice[right].y-vertice[left].y;
      if (!(dy>>16)) return;
      char side=((vertice[left].y)<(vertice[right].y)) ? left : right;
      edgeaddx[side]=dx/(dy>>16);
      fmid=0;
    }
    scradrl+=scrwidth<<16;
    scradrr+=scrwidth<<16;
  }
}

void DrawFlatLine (int, char);
#pragma aux DrawFlatLine=                 \
        "mov    edi, offset minx[ebx*4]"  \
        "add    edi, vscreen"             \
        "mov    ecx, offset maxx[ebx*4]"  \
        "sub    ecx, offset minx[ebx*4]"  \
        "js     ende"                     \
        "jz     ende"                     \
        "shl    ebx, 6"                   \
        "add    edi, ebx"                 \
        "shl    ebx, 2"                   \
        "add    edi, ebx"                 \
        "cld"                             \
        "mov    eax, edx"                 \
        "rep    stosb"                    \
    "ende:"                               \
        parm [ebx] [edx]                  \
        modify [eax ebx ecx edx edi];

extern "C"
{
void scanline (int x1, int y1, int x2, int y2, int *array);
#pragma aux scanline "_*" parm [] caller modify [eax ebx ecx edx esi edi]
}

void DrawFlatPolygonold (int numverts, flatpunkt *data, char color)
{
/*
  flatpunkt data[3];
  data[0].x=99;
  data[0].y=100;
  data[1].x=56;
  data[1].y=100;
  data[2].x=32;
  data[2].y=101;
*/
    int miny, maxy;
    int i;
    int currvert, nextvert, topvert, bottvert, headvert;

    if (numverts < 3) return;  // make sure there are > 2 verts

    // Find the top and bottom vertices of the polygon so that we know
    // which side is the left side and which is the right side

    currvert = topvert = bottvert = headvert = 0;
    miny = maxy = data[headvert].y;
    do
    {
      if (data[currvert].y < miny) {
        bottvert=currvert;
        miny = data[bottvert].y;
      } else {
        if (data[currvert].y > maxy) {
          topvert=currvert;
          maxy=data[topvert].y;
        }
      }
      currvert= (currvert < (numverts-1)) ? (currvert+1) : 0;

    } while (currvert != headvert);

    // Adjust the Minimal and Maximal-Values
    if (miny >= maxy) return;

    // Scan the right edge of the polygon
    currvert = topvert;
    do {
        nextvert= (currvert < (numverts-1)) ? (currvert+1) : 0;

        scanline (data[nextvert].x, data[nextvert].y,
                  data[currvert].x, data[currvert].y, maxx);
        currvert = nextvert;
    } while (nextvert != bottvert);

    // Scan the left edge of the polygon
    do {
        nextvert= (currvert < (numverts-1)) ? (currvert+1) : 0;
        scanline (data[currvert].x, data[currvert].y,
                  data[nextvert].x, data[nextvert].y, minx);
        currvert = nextvert;
    } while (nextvert != topvert);
    for (int count=miny+1; count<=maxy; count++)
      DrawFlatLine (count, color);
}

