/*
     Mouse Routines for WATCOM C++ 32-Bit FLAT-MEMORY

     (c) 1995 Nils Pipenbrinck

     V1.0  Wen 10-18-1995
*/

#ifndef __mouse_h
#define __mouse_h

extern void Mouse_Reset (void);
#pragma aux Mouse_Reset=  \
        "xor eax, eax"    \
        "int 0x33"        \
        modify [ax bx];

extern short MouseInstalled (void);
#pragma aux MouseInstalled=\
        "xor eax, eax"     \
        "int 0x33"         \
        modify [ax] value [ax];

extern void Mouse_Show (void);
#pragma aux Mouse_Show=   \
        "xor eax, eax"    \
        "mov al, 1"       \
        "int 0x33"        \
        modify [ax];

extern void Mouse_Hide (void);
#pragma aux Mouse_Hide=   \
        "xor eax, eax"    \
        "mov al, 2"       \
        "int 0x33"        \
        modify [ax];

extern void Mouse_Goto (short int x, short int y);
#pragma aux Mouse_Goto=   \
        "xor eax, eax"    \
        "mov al, 4"       \
        "int 0x33"        \
        modify [ax]       \
        parm [cx][dx];

extern void Mouse_SetXRange (short int min, short int max);
#pragma aux Mouse_SetXRange=   \
        "xor eax, eax"    \
        "mov al, 7"       \
        "int 0x33"        \
        modify [ax]       \
        parm [cx][dx];

extern void Mouse_SetYRange (short int min, short int max);
#pragma aux Mouse_SetYRange=   \
        "xor eax, eax"    \
        "mov al, 8"       \
        "int 0x33"        \
        modify [ax]       \
        parm [cx][dx];

extern short Mouse_getx (void);
#pragma aux Mouse_getx=   \
        "xor eax, eax"    \
        "mov al, 3"       \
        "int 0x33"        \
        modify [ax dx bx] \
        value [cx];

extern short Mouse_gety (void);
#pragma aux Mouse_gety=   \
        "xor eax, eax"    \
        "mov al, 3"       \
        "int 0x33"        \
        modify [ax cx bx] \
        value [dx];

extern short Mouse_Buttons (void);
#pragma aux Mouse_Buttons=\
        "xor eax, eax"    \
        "mov al, 3"       \
        "int 0x33"        \
        modify [cx ax dx] \
        value[bx];

extern void Mouse_Move (short int &x, short int &y);
#pragma aux Mouse_Move =  \
        "xor eax, eax"    \
        "mov al, 0x0b"    \
        "int 0x33"        \
        "mov [esi], cx"   \
        "mov [edi], dx"   \
        parm [esi][edi] modify [eax ecx edx];

#endif
