/**********************************************
	Simple 2D Bump Mapping
	by
	Marek Biskup
	marbis@kki.net.pl

***********************************************/



#include <math.h>
#include <stdlib.h>
void InitBump(unsigned char* pic,int* h,int* v, unsigned char* c)
{
	int nh,nv;
	int x,y,i = 321;
	for(y=1;y<199;y++,i+=2)
		for(x=1;x<319;x++,i++)
		{
			nh = pic[i+1] - pic[i-1];
			nv = pic[i+320] - pic[i-320];

			h[i] = nh - x;
			v[i] = nv - y;
		}
	int c1,c2;
	int col;
	for(c1=0,i=0;c1<128;c1++)
		for(c2=0;c2<128;c2++,i++)
		{
			col = sqrt(c1*c1+c2*c2);
			col = 126 - col;
			col *= 2;
			if(col<0) col = 0;
			c[i] = col;
		}

}

void bump(int Time,unsigned char* p,int Pitch,
				int* nh,int* nv,unsigned char* c)
{
	static double dAlpha = 0.0013;
	static double dBeta = 0.0017;

	int Lx = sin(Time*dAlpha)*150+160;
	int Ly = sin(Time*dBeta)*90+100;

	int x,y;
	int i = Pitch+1;
	int j = 320+1;
	int c1,c2;
	for(y=1;y<199;y++,i+=Pitch - 320 + 2,j+=2)
		for(x=1;x<319;x++,i++,j++)
		{
			c1 = Lx + nh[j];
			c2 = Ly + nv[j];

			if(c1<0) c1 = -c1;
			if(c2<0) c2 = -c2;
			if(c1>=126 || c2>=126 ) continue;

			p[i] = c[c1*128+c2];
		}
}

