/****************************************************
	WinMain function and the rest windows stuff
	by Wojciech Jawor (most), Microsoft and me
****************************************************/



#include <windows.h>


// ********************************************
BOOL bAktywny;			// czy program aktywny
HWND hMainWindow;
HINSTANCE hInstApp;
// ********************************************

extern BOOL MainLoop();
extern BOOL Inicjalizacja();
extern BOOL OdswiezEkran();
extern void ProceduraKonczaca();

long FAR PASCAL ObslugaKomunikatow(HWND, UINT, WPARAM, LPARAM);


BOOL AppInit(HINSTANCE hInst,HINSTANCE hPrev,LPSTR szCmdLine,int sw)
{
	/* Save instance handle for DialogBoxes */
	hInstApp = hInst;

	WNDCLASS KlasaOkna;
	KlasaOkna.style = 0;
	KlasaOkna.hInstance = hInst;
	KlasaOkna.lpszClassName = "nasza klasa";
	KlasaOkna.lpfnWndProc = ObslugaKomunikatow;
	KlasaOkna.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	KlasaOkna.hCursor = LoadCursor(NULL, IDC_ARROW);
	KlasaOkna.lpszMenuName = NULL;
	KlasaOkna.cbClsExtra = 0;
	KlasaOkna.cbWndExtra = 0;
	KlasaOkna.hbrBackground = (HBRUSH)1;

	// rejestrujemy okno
	if (!RegisterClass(&KlasaOkna)) return FALSE;

	// tworzymy okno
	HWND okno = CreateWindowEx(
							WS_EX_TOPMOST,
							"nasza klasa",
							"Program",
							WS_SYSMENU | WS_POPUP,
							0, 0,				//Position
							GetSystemMetrics(SM_CXSCREEN), GetSystemMetrics(SM_CYSCREEN), // Size
							NULL,          // Parent window
							NULL,
							hInst,			// handle to window instance
							NULL				// no params to pass on
							);

	// zapamitujemy uchwyt okna
	hMainWindow = okno;

	// wywietlamy je
	ShowWindow(okno, sw);
	UpdateWindow(okno);

	return TRUE;
}


int WINAPI WinMain(HINSTANCE hprogram, HINSTANCE, LPSTR, int tryb)
{

	AppInit(hprogram,0,0,tryb);	// okrelamy parametry okna

	// jeeli inicjalizacja si nie powiedzie to zakocz program
	if (!Inicjalizacja())
	{
		char buf[256];
		wsprintf(buf, "Nieprawidowa inicjalizacja\n", NULL);
		MessageBox(hMainWindow, buf, "Bd", MB_OK);
		ProceduraKonczaca();
		return 0;
	}

	MSG komunikat;
	while (1)
	{
		// sprawd czy doszy jakie komunikaty
		if(PeekMessage(&komunikat, NULL, 0, 0, PM_NOREMOVE))
		{
			// jeeli komunikat o wyjciu to mona skoczy
			if (GetMessage(&komunikat, NULL, 0, 0 ) == 0) return komunikat.wParam;

			// jeeli nie to wysyamy go do procedury, ktra go obsuy
			TranslateMessage(&komunikat);
			DispatchMessage(&komunikat);
		}
		else if (bAktywny)
		{
			if (!MainLoop()) return 0;
		}
		else
		{
			// jeeli nic to unij do nastpnego komunikatu
			WaitMessage();
		}
	}
} /* WinMain */

// ********************************************
// funkcja obsugujca komunikaty
long FAR PASCAL ObslugaKomunikatow(HWND hokno, UINT komunikat,
											  WPARAM wParam, LPARAM lParam )
{
	 switch(komunikat)
	 {
		case WM_ACTIVATEAPP:
			bAktywny = wParam;
		break;

		case WM_PAINT:
			OdswiezEkran();

		case WM_KEYDOWN:
			 switch (wParam)
		  {
				 case VK_ESCAPE:
					 PostMessage(hokno, WM_CLOSE, 0, 0);
				 break;
		  }
		 break;

		case WM_DESTROY:
			ProceduraKonczaca();
			PostQuitMessage(0);
		 break;
	}

	// automatyczna obsuga innych komunikatw
	 return DefWindowProc(hokno, komunikat, wParam, lParam);

} /* ObslugaKomunikatw */
