/****************************************************
	Implementation of the cScreen class
	most code by.....  microsoft :((
	the rest by
	Marek Biskup
	marbis@kki.net.pl
****************************************************/


#include <windows.h>
#include "screen.h"



cScreen::cScreen(void)
{
	dd = 0;
	FrontBuffer = 0;
	BackBuffer = 0;
	FillColor = RGB(0, 0, 0);
	textcolor = RGB(255, 255, 60);
}

cScreen::~cScreen(void)
{
	if (BackBuffer)	BackBuffer->Release(), 	BackBuffer = NULL;
	if (FrontBuffer)	FrontBuffer->Release(), FrontBuffer = NULL;
	if (dd)				dd->Release(),				dd = NULL;
}

BOOL cScreen::Flip(void)
{
	HRESULT ddrval = FrontBuffer->Flip(NULL,DDFLIP_WAIT);
	if (ddrval != DD_OK) return FALSE;
	else return TRUE;
}

void* cScreen::GetPointer(void)
{
	DDSURFACEDESC ddsd;	 // powierzchnia DD
	ddsd.dwSize = sizeof(ddsd);

	if(BackBuffer->Lock(NULL,&ddsd,DDLOCK_WAIT,NULL) == DD_OK)
	{
		lPitch = ddsd.lPitch;
		return ddsd.lpSurface;
	}
	else return 0;
}

int cScreen::FreePointer(void)
{
	if(BackBuffer->Unlock(NULL)!=DD_OK) return FALSE;
	else return TRUE;
}

int cScreen::Pitch(void)
{
	return lPitch;
}

BOOL cScreen::Restore(void)
{
	// odzyskujemy powierzchnie
	if (FrontBuffer != NULL) return (FrontBuffer->Restore());
	return FALSE;
}

void cScreen::clear(void)
{
	DDBLTFX ddbltfx;
	ddbltfx.dwSize = sizeof(ddbltfx);
	ddbltfx.dwFillColor = FillColor;

	BackBuffer->Blt(NULL, NULL, NULL, DDBLT_COLORFILL |
					DDBLT_WAIT, &ddbltfx);
}
void cScreen::Background(int r, int g, int b)
{
	FillColor = RGB(r,g,b);
}
void cScreen::TextColor(int r, int g, int b)
{
	textcolor = RGB(r,g,b);
}

void cScreen::print(char* cz,int x, int y)
{
	HDC hdc;
	if (BackBuffer->GetDC(&hdc) == DD_OK)
	{
		SetBkMode(hdc, TRANSPARENT);
		SelectObject(hdc, AppFont);

		SetTextColor(hdc, textcolor);
		TextOut(hdc, x, y, cz, strlen(cz));
		BackBuffer->ReleaseDC(hdc);
	}
}

void cScreen::SetPalette(void* p)
{
	BYTE* pc = (BYTE*) p;
	PALETTEENTRY pal[256];
	LPDIRECTDRAWPALETTE lpDDPal;

	for (int i=0; i<256; i++)
	{
		pal[i].peRed =   pc[i*3+0];
		pal[i].peGreen = pc[i*3+1];
		pal[i].peBlue =  pc[i*3+2];
		pal[i].peFlags = 0;
	}
	dd->CreatePalette(DDPCAPS_8BIT, pal, &lpDDPal, NULL);
	FrontBuffer->SetPalette(lpDDPal);
}

int cScreen::SetMode(int newwidth, int newheight, int newbpp)
{
	HRESULT err;
	width = newwidth;
	height = newheight;
	bpp = newbpp;

	err = dd->SetDisplayMode(width, height, bpp);

	if (err != DD_OK) return FALSE;

	// get rid of any previous surfaces.
	if (BackBuffer) BackBuffer->Release(),    BackBuffer = NULL;
	if (FrontBuffer) FrontBuffer->Release(),    FrontBuffer = NULL;

	//
	// Create surfaces
	//
	// what we want is a tripple buffered surface in video memory
	// so we try to create this first.
	//
	// if we cant get a triple buffered surface, we try again
	// for a double buffered surface (still must be in video memory)
	//
	// if we cant get a double buffered surface, we try for a double
	// buffered surface not being specific about video memory, we will
	// get back a main-memory surface, that work use HW page flipping
	// but at least we run.
	//
	// NOTE you need to recreate the surfaces for a new display mode
	// they wont work when/if the mode is changed.
	//

	DDSURFACEDESC ddsd;

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.dwBackBufferCount = 2;
	ddsd.ddsCaps.dwCaps =  DDSCAPS_PRIMARYSURFACE |
								  DDSCAPS_FLIP |
								  DDSCAPS_COMPLEX |
								  DDSCAPS_VIDEOMEMORY;

	// try to get a triple buffered video memory surface.
	err = dd->CreateSurface(&ddsd, &FrontBuffer, NULL);

	if (err != DD_OK)
	{
		// try to get a double buffered video memory surface.
		ddsd.dwBackBufferCount = 1;
		err = dd->CreateSurface(&ddsd, &FrontBuffer, NULL);
	}
	if (err != DD_OK)
	{
		// settle for a main memory surface.
		ddsd.ddsCaps.dwCaps &= ~DDSCAPS_VIDEOMEMORY;
		err = dd->CreateSurface(&ddsd, &FrontBuffer, NULL);
	}
	if (err != DD_OK)
		return FALSE;

	// get a pointer to the back buffer
	DDSCAPS caps;
	caps.dwCaps = DDSCAPS_BACKBUFFER;
	err = FrontBuffer->GetAttachedSurface(&caps, &BackBuffer);

	if (err != DD_OK)
		return FALSE;

	if (AppFont)
		DeleteObject(AppFont);

	AppFont = CreateFont(width < 640 ? 24 : 48,
		  0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE,
		  ANSI_CHARSET,
		  OUT_DEFAULT_PRECIS,
		  CLIP_DEFAULT_PRECIS,
		  NONANTIALIASED_QUALITY,
		  VARIABLE_PITCH,
		  "Comic Sans MS");

	return TRUE;
}

int cScreen::init(HWND hMainWindow,int w, int h, int d)
{
	HRESULT ddrval;
	// tworzy glowny obiekt DD
	ddrval = DirectDrawCreate(NULL, &dd, NULL);
	if (ddrval != DD_OK) return FALSE;

	// wlacz restrykcje na dostep do ekranu
	ddrval = dd->SetCooperativeLevel(hMainWindow,
				DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN);
	if (ddrval != DD_OK) return FALSE;

	if(!SetMode(w,h,d))
		return FALSE;
	return TRUE;
}



